package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.state.SocketStateAdapter;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;

/**
 * Created by nirni on 3/9/16.
 */
public class CloseConnectionTask extends BaseAmsAccountConnectionTask{

	private static final String TAG = "CloseConnectionTask";
	private AccountsController mAccountsController;

	public CloseConnectionTask(AccountsController accountsController) {
		mAccountsController = accountsController;
	}

	@Override
	public void execute() {
		LPLog.INSTANCE.d(TAG, "Running close socket task...");
		AmsConnectionAnalytics.closeConnectionTaskStart();

		String connectionUrl = mAccountsController.getConnectionUrl(mBrandId);
		SocketState state = SocketManager.getInstance().getSocketState(connectionUrl);
		LPLog.INSTANCE.i(TAG, "Current socket state: " + state);
		switch (state) {
			case CONNECTING:
			case CLOSING:
			case OPEN:
				registerToSocketState(connectionUrl);
				SocketManager.getInstance().disconnect(connectionUrl);
				break;
			default: //INIT, CLOSED
				mCallback.onTaskSuccess();
				//mCallback.onTaskError(TaskType.OPEN_SOCKET, new Exception("Failed closing socket"));
				break;
		}

	}
	private void registerToSocketState(final String connectionUrl) {
		SocketManager.getInstance().registerToSocketState(connectionUrl, new SocketStateAdapter() {
			@Override
			public void onStateChanged(SocketState state) {
				LPLog.INSTANCE.i(TAG, "new socket state:" + state.name());
				switch (state) {
					case ERROR:
					case CLOSED:
						SocketManager.getInstance().unregisterFromSocketState(connectionUrl, this);
						AmsConnectionAnalytics.closeConnectionTaskEnd();
						mCallback.onTaskSuccess();
						break;
					default:
						break;
				}
			}
		});
	}

	@Override
	public String getName() {
		return TAG;
	}
}
