package com.liveperson.messaging.model;

import com.liveperson.infra.Command;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.controller.ConnectionsController;

/**
 * Created by dudu on 12/21/16.
 */

public class SynchronizedAmsConnectionUpdateCallback implements Command {

    private static final String TAG = "SynchronizedAmsConnectionUpdateCallback";
    private final ConnectionsController mConnectionController;

    private String mBrandId;
    private boolean handled = false;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;
    private Runnable mCallback;

    /**
     * Synchronously listening to when connection is accomplished
     *
     * @param connectionController
     * @param callback
     */
    public SynchronizedAmsConnectionUpdateCallback(ConnectionsController connectionController, String brandId, Runnable callback) {
        mConnectionController = connectionController;
        mBrandId = brandId;
        mCallback = callback;

    }

    @Override
    public void execute() {
        registerToConnectionStateChanges();
        validateStatusDidNotChangedDuringRegistration();
    }

    private void registerToConnectionStateChanges() {
        mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder()
                .addAction(AmsConnection.BROADCAST_AMS_CONNECTION_UPDATE_ACTION)
                .build((context, intent) -> {
	                LPLog.INSTANCE.d(TAG, "received BROADCAST_AMS_CONNECTION_UPDATE_ACTION - call connection update");

                    boolean isUpdated = intent.getBooleanExtra(AmsConnection.BROADCAST_AMS_CONNECTION_UPDATE_EXTRA, false);
                    if (isUpdated) {
                        handleConnectionUpdated();
                    }
                });
    }

    private synchronized void validateStatusDidNotChangedDuringRegistration() {
        if (!handled) {
            if (mConnectionController.isUpdated(mBrandId)) {
                handleConnectionUpdated();
            }
        }
    }

    private synchronized void handleConnectionUpdated() {
        if (handled) {
            return;
        }
        if (mLocalBroadcastReceiver != null) {
            mLocalBroadcastReceiver.unregister();
        }
        handled = true;
        mCallback.run();
    }

}
