/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request.message;

import com.liveperson.api.request.message.BasePublishMessage;
import com.liveperson.infra.log.LPLog;
import org.json.JSONException;
import org.json.JSONObject;

public class FilePublishMessage
extends BasePublishMessage {
    private static final String TAG = "FilePublishMessage";
    public static final String CAPTION = "caption";
    public static final String RELATIVE_PATH = "relativePath";
    public static final String FILE_TYPE = "fileType";
    public static final String PREVIEW = "preview";
    private String caption;
    private String relativePath;
    private String fileType;
    private String preview;

    public FilePublishMessage(String caption, String relativePath, String fileType, String preview) {
        this.caption = caption;
        this.relativePath = relativePath;
        this.fileType = fileType;
        this.preview = preview;
    }

    public FilePublishMessage(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.caption = jsonObject.optString(CAPTION);
            this.caption = this.caption.trim();
            this.relativePath = jsonObject.optString(RELATIVE_PATH);
            this.fileType = jsonObject.optString(FILE_TYPE);
            this.preview = jsonObject.optString(PREVIEW);
        }
    }

    public JSONObject getMessage() {
        JSONObject msgJson = new JSONObject();
        try {
            msgJson.put(CAPTION, (Object)this.caption);
            msgJson.put(RELATIVE_PATH, (Object)this.relativePath);
            msgJson.put(FILE_TYPE, (Object)this.fileType);
            msgJson.put(PREVIEW, (Object)this.preview);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.d(TAG, "Can't create file message:");
        }
        return msgJson;
    }

    @Override
    public BasePublishMessage.PublishMessageType getType() {
        return BasePublishMessage.PublishMessageType.FILE;
    }

    @Override
    public String getMessageText() {
        return this.getMessageTextWithoutSpecialChars(this.caption);
    }

    public String getCaption() {
        return this.caption;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getPreview() {
        return this.preview;
    }
}

