/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.GetUnreadMessagesCountFromUMSCommand;
import com.liveperson.messaging.commands.pusher.GetUnreadMessagesCountCommand;

public class GetCombinedUnreadMessagesCountCommand
implements Command {
    private static final String TAG = "GetCombinedUnreadMessagesCountCommand";
    private Messaging mController;
    private String mBrandId;
    private ICallback<Integer, Exception> mCallback;
    private String mAppId;
    private LPAuthenticationParams authenticationParams;

    public GetCombinedUnreadMessagesCountCommand(Messaging messagingController, String brandId, String appId, LPAuthenticationParams authenticationParams, ICallback<Integer, Exception> callback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.mCallback = callback;
        this.authenticationParams = authenticationParams;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Getting unread count from pusher");
        this.getUnreadMessageCountFromPusher();
    }

    private void getUnreadMessageCountFromPusher() {
        new GetUnreadMessagesCountCommand(this.mController, this.mBrandId, this.mAppId, this.authenticationParams, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                GetCombinedUnreadMessagesCountCommand.this.mCallback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                LPLog.INSTANCE.d(GetCombinedUnreadMessagesCountCommand.TAG, "getUnreadMessageCountFromPusher: Pusher returned error: " + exception);
                GetCombinedUnreadMessagesCountCommand.this.getUnreadMessageCountFromUMS();
            }
        }).execute();
    }

    private void getUnreadMessageCountFromUMS() {
        LPLog.INSTANCE.d(TAG, "Getting unread count from UMS");
        new GetUnreadMessagesCountFromUMSCommand(this.mController, this.mBrandId, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                GetCombinedUnreadMessagesCountCommand.this.mCallback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                GetCombinedUnreadMessagesCountCommand.this.mCallback.onError((Throwable)exception);
            }
        }).execute();
    }
}

