/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.ResolveConversationCommand;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.MessageTimeoutQueue;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;

public class SendMessageCommand
implements Command {
    private static final String TAG = "SendMessageCommand";
    protected final Messaging mController;
    protected String mBrandId;
    protected String mTargetId;
    protected MaskedMessage mMessage;
    protected String mConsumerId;
    protected String mEventId;
    protected DeliveryStatusUpdateInfo mInfo;

    public SendMessageCommand(Messaging controller, String targetId, String brandId, MaskedMessage message) {
        this.mController = controller;
        this.mBrandId = brandId;
        this.mTargetId = targetId;
        this.mMessage = message;
    }

    public SendMessageCommand(Messaging controller, String targetId, String brandId, MaskedMessage message, @Nullable DeliveryStatusUpdateInfo info) {
        this(controller, targetId, brandId, message);
        this.mInfo = info;
    }

    public void execute() {
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        Conversation conversation = this.mController.amsConversations.getConversationFromTargetIdMap(this.mTargetId);
        boolean isConversationOpen = conversation != null && conversation.getState() == ConversationState.OPEN;
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        if (!isConversationOpen) {
            this.sendOnNewConversation();
        } else if (dialog == null) {
            LPLog.INSTANCE.w(TAG, "'Zombie Conversation' state occurred (One conversation is open without open dialogs) while the consumer is trying to send a message! Closing this conversation and open a new one....");
            ResolveConversationCommand resolveConversationCommand = new ResolveConversationCommand(this.mController.amsConversations, this.mTargetId, this.mController.mAccountsController.getConnectionUrl(this.mBrandId));
            resolveConversationCommand.setCallback(new ICallback<String, Throwable>(){

                public void onSuccess(String value) {
                    SendMessageCommand.this.sendOnNewConversation();
                }

                public void onError(Throwable error) {
                    LPLog.INSTANCE.e(SendMessageCommand.TAG, "Failed to resolve conversation before creating a new one, continuing with creating anyway", error);
                    SendMessageCommand.this.sendOnNewConversation();
                }
            });
            resolveConversationCommand.execute();
        } else {
            LPLog.INSTANCE.d(TAG, "Send message - dialog = " + dialog.getDialogId() + ", " + (Object)((Object)dialog.getState()));
            switch (dialog.getState()) {
                case CLOSE: {
                    this.sendOnNewConversation();
                    break;
                }
                case LOCKED: {
                    break;
                }
                case OPEN: 
                case PENDING: 
                case QUEUED: {
                    this.addMessageToDBAndSend(dialog.getDialogId(), this.mMessage);
                }
            }
        }
    }

    private void sendOnNewConversation() {
        BaseAMSSocketRequest newConversationRequest = this.createPendingConversationAndDialog();
        this.sendCreateConversationRequest(newConversationRequest);
        this.addMessageToDBAndSend("TEMP_DIALOG", this.mMessage);
        LPLog.INSTANCE.d(TAG, "sendOnNewConversation: " + LPLog.INSTANCE.mask((Object)this.mMessage));
    }

    protected BaseAMSSocketRequest createPendingConversationAndDialog() {
        NewConversationRequest newConversationRequest = this.createNewConversationRequest();
        this.mController.amsConversations.createPendingConversation(this.mTargetId, this.mBrandId, newConversationRequest.getRequestId());
        this.mController.amsDialogs.createPendingDialog(this.mTargetId, this.mBrandId, newConversationRequest.getRequestId());
        return newConversationRequest;
    }

    private NewConversationRequest createNewConversationRequest() {
        return this.createNewConversationRequest("TEMP_CONVERSATION", "TEMP_DIALOG", null);
    }

    protected NewConversationRequest createNewConversationRequest(String tempConversationId, String tempDialogId, Long requestId) {
        NewConversationRequest newConversationRequest = new NewConversationRequest(this.mController, this.mTargetId, this.mBrandId, tempConversationId, tempDialogId);
        if (requestId != null) {
            newConversationRequest.setRequestId(requestId);
        }
        this.mController.amsConversations.enqueuePendingConversationRequestId(newConversationRequest.getRequestId());
        return newConversationRequest;
    }

    public void sendCreateConversationRequest(BaseAMSSocketRequest newConversationRequest) {
        SocketManager.getInstance().send((BaseSocketRequest)newConversationRequest);
    }

    protected void sendMessage(String conversationId, String dialogId, String message) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, conversationId, dialogId, message);
        this.sendMessage(dialogId, sendMessageRequest);
    }

    protected void sendMessage(String dialogId, SendMessageRequest sendMessageRequest) {
        SocketManager.getInstance().send((BaseSocketRequest)sendMessageRequest);
        this.mController.amsMessages.mMessageTimeoutQueue.add(MessageTimeoutQueue.MessageType.PUBLISH, (int)sendMessageRequest.getRequestId(), this.mBrandId, dialogId, this.mEventId);
    }

    protected void sendMessageIfDialogIsOpen() {
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        if (dialog != null) {
            LPLog.INSTANCE.d(TAG, "sendMessageIfDialogIsOpen: " + (Object)((Object)dialog.getState()));
            if (dialog.getState() == DialogState.OPEN) {
                SendMessageRequest sendMessageRequest = this.createMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, dialog.getDialogId(), dialog.getConversationId());
                this.sendMessage(dialog.getDialogId(), sendMessageRequest);
            } else if (dialog.getState() == DialogState.PENDING) {
                SendMessageRequest sendMessageRequest = this.createMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, dialog.getDialogId(), dialog.getConversationId());
                dialog.getPendingData().addToPendingRequests(sendMessageRequest);
            } else {
                LPLog.INSTANCE.e(TAG, "sendMessageIfDialogIsOpen: unhandled dialog state:" + (Object)((Object)dialog.getState()));
            }
        } else {
            LPLog.INSTANCE.e(TAG, "sendMessageIfDialogIsOpen: Failed to find an active dialog!");
        }
    }

    protected void addMessageToDBAndSend(String dialogId, MaskedMessage message) {
        this.mEventId = UniqueID.createUniqueMessageEventId();
        LPLog.INSTANCE.i(TAG, "addMessageToDBAndSend: mEventId = " + this.mEventId + " dialog ID = " + dialogId);
        MessagingChatMessage chatMessage = this.createNewChatMessage(dialogId, message);
        if (this.mInfo != null && this.mInfo.getMetadata() != null) {
            chatMessage.setMetadata(this.mInfo.getMetadata().toString());
        }
        this.mController.amsMessages.addMessage(chatMessage, true).setPostQueryOnBackground(data -> {
            LPLog.INSTANCE.i(TAG, "Send message, time: " + chatMessage.getTimeStamp());
            this.sendMessageIfDialogIsOpen();
        }).execute();
        if (this.mMessage.isMasked()) {
            String maskedEventId = UniqueID.createUniqueMessageEventId();
            MessagingChatMessage warning = new MessagingChatMessage(chatMessage.getOriginatorId(), message.getMaskedSystemMessage(), chatMessage.getTimeStamp() + 1L, chatMessage.getDialogId(), maskedEventId, MessagingChatMessage.MessageType.SYSTEM_MASKED, MessagingChatMessage.MessageState.RECEIVED, -3, ContentType.text_plain.getText(), EncryptionVersion.NONE);
            this.mController.amsMessages.addMessage(warning, true).execute();
        }
    }

    @NonNull
    protected MessagingChatMessage createNewChatMessage(String dialogId, MaskedMessage message) {
        return new MessagingChatMessage(this.mConsumerId, message.getDbMessage(), System.currentTimeMillis(), dialogId, this.mEventId, message.isMasked() ? MessagingChatMessage.MessageType.CONSUMER_MASKED : MessagingChatMessage.MessageType.CONSUMER, MessagingChatMessage.MessageState.PENDING, EncryptionVersion.NONE);
    }

    @NonNull
    protected SendMessageRequest createMessageRequest(Messaging mController, String mEventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(mController, mEventId, mTargetId, mBrandId, dialogId, conversationId);
        sendMessageRequest.setMessageContent(this.mMessage.getServerMessage());
        sendMessageRequest.setInfo(this.mInfo);
        return sendMessageRequest;
    }

    public String getEventId() {
        return this.mEventId;
    }
}

