/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpPutRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SendReadAcknowledgementCommand
implements Command {
    private static final String TAG = "SendReadAcknowledgementCommand";
    static final String CONSUMER_ID = "consumerId";
    static final String CONVERSATION_IDS = "conversationIds";
    private static final String PUSHER_URL = "https://%s/api/account/%s/device/read-ack";
    private final Messaging messagingController;
    private String brandId;
    private static HashSet<String> acknowledgedConversationIds;
    private String dialogId;
    private String conversationId;
    private ICallback<String, Exception> callback;

    public SendReadAcknowledgementCommand(Messaging messagingController, String brandId, String dialogId, String conversationId, ICallback<String, Exception> callback) {
        this.messagingController = messagingController;
        this.brandId = brandId;
        this.dialogId = dialogId;
        this.conversationId = conversationId;
        this.callback = callback;
    }

    public void execute() {
        if (acknowledgedConversationIds == null) {
            acknowledgedConversationIds = new HashSet();
        }
        LPConversationsHistoryStateToDisplay historyStateToDisplay = this.messagingController.getConversationViewParams().getHistoryConversationsStateToDisplay();
        boolean isDialogClosed = this.messagingController.isDialogClosed(this.dialogId);
        LPLog.INSTANCE.d(TAG, "isDialog " + this.dialogId + " Closed: " + isDialogClosed + " historyStateToDisplay: " + historyStateToDisplay);
        if (isDialogClosed && historyStateToDisplay == LPConversationsHistoryStateToDisplay.OPEN || !isDialogClosed && historyStateToDisplay == LPConversationsHistoryStateToDisplay.CLOSE || !ForegroundService.getInstance().isBrandForeground(this.brandId)) {
            return;
        }
        if (acknowledgedConversationIds.contains(this.conversationId)) {
            LPLog.INSTANCE.d(TAG, "Already acknowledged conversation: " + this.conversationId);
            this.callback.onSuccess((Object)this.conversationId);
            return;
        }
        acknowledgedConversationIds.add(this.conversationId);
        String pusherDomain = this.messagingController.mAccountsController.getServiceUrl(this.brandId, "pusher");
        String requestURL = String.format(PUSHER_URL, pusherDomain, this.brandId);
        this.validateStateAndSendRequest(requestURL);
    }

    private void validateStateAndSendRequest(String requestURL) {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.sendRequest(requestURL);
        } else {
            new SynchronizedInternetConnectionCallback(() -> this.sendRequest(requestURL)).execute();
        }
    }

    private void sendRequest(String requestURL) {
        String token = this.messagingController.mAccountsController.getToken(this.brandId);
        JSONObject requestJson = this.getBody();
        HttpPutRequest httpPutRequest = new HttpPutRequest(requestURL);
        LPJSONObjectBody jsonBody = new LPJSONObjectBody(requestJson);
        httpPutRequest.setBody((HttpRequestBody)jsonBody);
        httpPutRequest.addHeader("authorization", "bearer " + token);
        httpPutRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String value) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)value)) {
                        LPLog.INSTANCE.d(SendReadAcknowledgementCommand.TAG, "onSuccess: " + value);
                        JSONArray jsonArray = new JSONArray(value);
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            JSONObject obj = jsonArray.getJSONObject(i);
                            String id = obj.getString("conversationId");
                            SendReadAcknowledgementCommand.this.callback.onSuccess((Object)id);
                        }
                    } else {
                        LPLog.INSTANCE.e(SendReadAcknowledgementCommand.TAG, "Received empty response from pusher for read ack request");
                    }
                }
                catch (JSONException error) {
                    LPLog.INSTANCE.e(SendReadAcknowledgementCommand.TAG, "Failed to parse read-ack response: ", (Throwable)error);
                }
            }

            public void onError(Exception exception) {
                if (exception != null) {
                    try {
                        String mess = SendReadAcknowledgementCommand.this.parseException(exception.getMessage());
                        JSONObject error = new JSONObject(mess);
                        String errorString = error.getString("error");
                        if (!TextUtils.isEmpty((CharSequence)errorString)) {
                            JSONObject errorBody = new JSONObject(errorString);
                            String statusCode = errorBody.getString("statusCode");
                            String internalCode = errorBody.getString("internalCode");
                            if (!statusCode.equals("404") && !internalCode.equals("23")) {
                                LPLog.INSTANCE.e(SendReadAcknowledgementCommand.TAG, "Failed to send read acknowledgement to pusher pusher.", (Throwable)exception);
                            } else {
                                SendReadAcknowledgementCommand.this.callback.onSuccess((Object)"");
                            }
                        }
                    }
                    catch (Exception e) {
                        LPLog.INSTANCE.e(SendReadAcknowledgementCommand.TAG, "Failed to parse unread message count exception from pusher.", (Throwable)e);
                    }
                }
            }
        });
        LPLog.INSTANCE.d(TAG, "Sending read ack to pusher for: " + this.conversationId);
        HttpHandler.execute((HttpRequest)httpPutRequest);
    }

    @NonNull
    protected JSONObject getBody() {
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put(CONSUMER_ID, (Object)this.messagingController.amsUsers.getConsumerId(this.brandId));
            JSONArray ids = new JSONArray();
            ids.put(0, (Object)this.conversationId);
            requestBody.put(CONVERSATION_IDS, (Object)ids);
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, "getBody: ", (Throwable)error);
        }
        return requestBody;
    }

    private String parseException(String exception) {
        return exception.substring(exception.indexOf(123));
    }

    public static void clearAcknowledgedConversations() {
        if (acknowledgedConversationIds != null) {
            LPLog.INSTANCE.d(TAG, "Removing all cached conversation ids");
            acknowledgedConversationIds.clear();
        }
    }
}

