/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.UnregisterPushRequest;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.List;

public class UnregisterPusherCommand
implements Command {
    private static final String TAG = "UnregisterPusherCommand";
    private static final String PUSHER_UNREGISTER_URL = "https://%s/api/account/%s/device/unregister?v=2.0";
    private final AccountsController mAccountsController;
    private final AmsUsers mAmsUsers;
    private String mBrandId;
    private String mAppId;
    private ICallback<Void, Exception> listener;
    private boolean runImmediately;

    public UnregisterPusherCommand(AccountsController accountsController, AmsUsers amsUsers, String brandId, String appId, ICallback<Void, Exception> listener, boolean immediately) {
        this.mAccountsController = accountsController;
        this.mAmsUsers = amsUsers;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.listener = listener;
        this.runImmediately = immediately;
    }

    public void execute() {
        LPLog.INSTANCE.i(TAG, "execute unregister for brandId " + this.mBrandId);
        String pusherDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "pusher");
        if (TextUtils.isEmpty((CharSequence)pusherDomain) && TextUtils.isEmpty((CharSequence)(pusherDomain = PreferenceManager.getInstance().getStringValue("pusher", this.mBrandId, null)))) {
            LPLog.INSTANCE.w(TAG, "pusherDomain does not exists. Quit unregister push");
            this.notifySuccess();
            return;
        }
        String url = String.format(PUSHER_UNREGISTER_URL, pusherDomain, this.mBrandId);
        try {
            if (this.runImmediately && this.mAccountsController.getAccount(this.mBrandId) != null && !this.mAccountsController.getAccount(this.mBrandId).isAuthenticated()) {
                url = url.substring(0, url.indexOf(63));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String pusherURL = url;
        String consumerId = this.mAmsUsers.getConsumerId(this.mBrandId);
        if (TextUtils.isEmpty((CharSequence)consumerId)) {
            LPLog.INSTANCE.d(TAG, "execute: consumerId is not available. Trying to get from DB...");
            this.mAmsUsers.getConsumerByBrandIDFromDB(this.mBrandId).setPostQueryOnBackground(dbConsumerId -> {
                if (!TextUtils.isEmpty((CharSequence)dbConsumerId)) {
                    this.runUnregisterPush((String)dbConsumerId, pusherURL);
                    LPLog.INSTANCE.d(TAG, "onResult: got  consumerId from DB (" + dbConsumerId + "). Unregister push with it...");
                } else {
                    LPLog.INSTANCE.w(TAG, "onResult: Cannot get user profile from DB. Quit unregister push");
                }
            }).execute();
        } else {
            this.runUnregisterPush(consumerId, pusherURL);
        }
    }

    private void notifySuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(null);
        }
    }

    private void runUnregisterPush(String consumerId, String pusherURL) {
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        if (this.runImmediately) {
            LPLog.INSTANCE.d(TAG, "run: Unregister push immediately");
            if (InternetConnectionService.isNetworkAvailable()) {
                new UnregisterPushRequest(pusherURL, consumerId, this.mAppId, certificates).setCallback(this.listener).execute();
            } else if (this.listener != null) {
                this.listener.onError((Throwable)new Exception("No network available"));
            }
        } else {
            new SynchronizedInternetConnectionCallback(() -> {
                LPLog.INSTANCE.d(TAG, "run: Unregister push for consumerId: " + LPLog.INSTANCE.mask((Object)consumerId));
                new UnregisterPushRequest(pusherURL, consumerId, this.mAppId, certificates).setCallback(this.listener).execute();
            }).execute();
        }
    }
}

