/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller;

import android.net.Uri;
import android.text.TextUtils;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.controller.ClientProperties;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.model.AmsAccount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountsController
implements Clearable {
    private static final String TAG = "AccountsController";
    public static final String QA_CSDS_DOMAIN = "hc1n.dev.lprnd.net";
    public static final String ALPHA_CSDS_DOMAIN = "adminlogin.liveperson.net";
    private static final String SOCKET_URL = "wss://%1$s/ws_api/account/%2$s/messaging/consumer";
    private static final String DOMAIN_VERSION_QUERY = "v";
    private static final int DOMAIN_VERSION_VALUE = 3;
    private Map<String, AmsAccount> mAccounts = new HashMap<String, AmsAccount>();
    private ClientProperties mClientProperties;

    public AccountsController(ClientProperties clientProperties) {
        this.mClientProperties = clientProperties;
    }

    public void addNewAccount(String brand) {
        if (this.getAccount(brand) == null) {
            LPLog.INSTANCE.i(TAG, "Adding new account: " + brand);
            this.mAccounts.put(brand, new AmsAccount(brand));
        }
    }

    public String getToken(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return null;
        }
        return account.getToken();
    }

    public List<String> getCertificatePinningKeys(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return null;
        }
        return account.getCertificatePinningKeys();
    }

    public boolean isTokenExpired(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return false;
        }
        return account.isTokenExpired() || account.isHostAppJWTExpired();
    }

    public LPAuthenticationParams getLPAuthenticationParams(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return null;
        }
        return account.getLPAuthenticationParams();
    }

    public void setLPAuthenticationParams(String brand, LPAuthenticationParams lpAuthenticationParams) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return;
        }
        account.setLPAuthenticationParams(lpAuthenticationParams);
    }

    public void setToken(String brand, String token) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return;
        }
        account.setToken(token);
    }

    public boolean setCSDSMap(String brand, HashMap<String, String> csdsUrls) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return false;
        }
        boolean dataUpdatedWithNewValue = account.setCSDSMap(csdsUrls);
        this.initLoggos(brand);
        return dataUpdatedWithNewValue;
    }

    private void initLoggos(String brand) {
        String loggosDomain = this.getServiceUrl(brand, "loggos");
        List<String> certificates = this.getCertificatePinningKeys(brand);
        Infra.instance.getLoggos().init(brand, loggosDomain, certificates);
    }

    public boolean isCsdsDataMissing(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return false;
        }
        return account.isCsdsDataMissing();
    }

    public String getDomain(String brand) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return null;
        }
        return account.getDomain();
    }

    public String getServiceUrl(String brand, String serviceName) {
        AmsAccount account = this.getAccount(brand);
        if (account == null) {
            return null;
        }
        return account.getServiceUrl(serviceName);
    }

    public IConnectionParamsCache getConnectionParamsCache(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            return null;
        }
        return account.getConnectionParamsCache();
    }

    public boolean isAutoMessagesEnabled(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            return false;
        }
        return account.isAutoMessagesEnabled();
    }

    public String getConnectionUrl(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            return null;
        }
        String connectionUrl = account.getServiceUrl("asyncMessagingEnt");
        String token = account.getToken();
        if (TextUtils.isEmpty((CharSequence)connectionUrl) || TextUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        String path = String.format(SOCKET_URL, connectionUrl, brandId);
        Uri fullUri = Uri.parse((String)path).buildUpon().appendQueryParameter(DOMAIN_VERSION_QUERY, String.valueOf(3)).build();
        return fullUri.toString();
    }

    public String getTokenizerUrl(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            return null;
        }
        return account.getServiceUrl("tokenizer");
    }

    public String getConnectionUrlForLogs(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            return null;
        }
        String connectionUrl = account.getServiceUrl("asyncMessagingEnt");
        String token = account.getToken();
        if (TextUtils.isEmpty((CharSequence)connectionUrl) || TextUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        return String.format(SOCKET_URL, connectionUrl, brandId);
    }

    public AmsAccount getAccount(String brand) {
        return this.mAccounts.get(brand);
    }

    public void clear() {
        this.mAccounts.clear();
    }

    public ClientProperties getClientProperties() {
        return this.mClientProperties;
    }

    public boolean isInUnAuthMode(String brandId) {
        AmsAccount account = this.getAccount(brandId);
        if (account == null) {
            return false;
        }
        return account.isInUnAuthMode();
    }
}

