/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.database.Cursor;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.model.Participants;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.PendingDialogData;
import com.liveperson.messaging.model.TTRManager;

public class Dialog {
    private static final String TAG = "Dialog";
    public static final String TEMP_DIALOG_ID = "TEMP_DIALOG";
    private String mConversationId;
    private String mDialogId;
    private DialogType mDialogType;
    private MultiDialog.ChannelType mChannelType;
    private Participants mParticipants = new Participants();
    private String mTargetId;
    private String mBrandId;
    private DialogState mState;
    private TTRType mConversationTTRType = TTRType.NORMAL;
    private String mAssignedAgentId;
    private long mRequestId;
    private int mLastServerSequence = -1;
    private long mStartTimestamp;
    private long mEndTimestamp = -1L;
    private int mUnreadMessages;
    private CSAT.CSAT_SHOW_STATUS mShowedCSAT = CSAT.CSAT_SHOW_STATUS.NO_VALUE;
    private int mUpdateInProgress = 0;
    private CloseReason mCloseReason = null;
    private TTRManager mTTRManager;
    private PendingDialogData mPendingDialogData = new PendingDialogData();

    public Dialog(String targetId, String brandId) {
        this.mTargetId = targetId;
        this.mBrandId = brandId;
        this.mTTRManager = new TTRManager(this.mTargetId);
        this.mChannelType = MultiDialog.ChannelType.MESSAGING;
    }

    @Deprecated
    public Dialog(ConversationData data) {
        this(data.targetId, data.brandId);
        LPLog.INSTANCE.e(TAG, "The new UMS is not with us, we're communicating with a legacy UMS");
        this.mConversationId = data.conversationId;
        this.mDialogId = DialogData.extractDialogId(data);
        this.mDialogType = DialogType.MAIN;
        this.mChannelType = MultiDialog.ChannelType.MESSAGING;
        this.mRequestId = data.requestId;
        this.mState = DialogState.parse(data.state);
        this.mConversationTTRType = data.conversationTTRType;
        this.mAssignedAgentId = data.getAssignedAgentId();
        this.mStartTimestamp = data.startTs;
        this.mUnreadMessages = data.unreadMessages;
        this.mCloseReason = data.closeReason;
        this.mEndTimestamp = data.endTs;
    }

    public Dialog(Cursor cursor) {
        this(cursor.getString(cursor.getColumnIndex("target_id")), cursor.getString(cursor.getColumnIndex("brand_id")));
        this.mConversationId = cursor.getString(cursor.getColumnIndex("conversation_id"));
        this.mDialogId = cursor.getString(cursor.getColumnIndex("dialog_id"));
        this.mDialogType = DialogType.parse(cursor.getString(cursor.getColumnIndex("dialog_type")));
        this.mChannelType = MultiDialog.ChannelType.parse(cursor.getString(cursor.getColumnIndex("channel_type")));
        int active = cursor.getInt(cursor.getColumnIndex("state"));
        this.mState = DialogState.values()[active];
        this.mRequestId = cursor.getLong(cursor.getColumnIndex("request_id"));
        this.mLastServerSequence = cursor.getInt(cursor.getColumnIndex("last_server_sequence"));
        this.mAssignedAgentId = cursor.getString(cursor.getColumnIndex("assigned_agent_id"));
        int ttrType = cursor.getInt(cursor.getColumnIndex("ttr_type"));
        if (ttrType != -1) {
            this.mConversationTTRType = TTRType.values()[ttrType];
        }
        int csatShownStatus = cursor.getInt(cursor.getColumnIndex("csat_status"));
        this.mShowedCSAT = CSAT.CSAT_SHOW_STATUS.parse(csatShownStatus);
        this.mEndTimestamp = cursor.getLong(cursor.getColumnIndex("end_timestamp"));
        int closeReasonInt = cursor.getInt(cursor.getColumnIndex("close_reason"));
        if (closeReasonInt != -1) {
            this.mCloseReason = CloseReason.values()[closeReasonInt];
        }
        this.mUnreadMessages = cursor.getInt(cursor.getColumnIndex("unread_msg_count"));
        this.mStartTimestamp = cursor.getLong(cursor.getColumnIndex("start_timestamp"));
        this.mUpdateInProgress = cursor.getInt(cursor.getColumnIndex("concurrent_requests_counter"));
    }

    public Dialog(DialogData dialogData, ConversationData conversationData) {
        this(conversationData.targetId, conversationData.brandId);
        this.mState = dialogData.isOpen ? DialogState.OPEN : DialogState.CLOSE;
        this.mParticipants = dialogData.participantsDetails;
        this.mConversationId = dialogData.conversationId;
        this.mDialogId = dialogData.dialogId;
        this.mDialogType = dialogData.dialogType;
        this.mChannelType = dialogData.channelType;
        this.mCloseReason = dialogData.closeReason;
        this.mState = dialogData.state;
        this.mRequestId = conversationData.requestId;
        this.mConversationTTRType = conversationData.conversationTTRType;
        this.mAssignedAgentId = conversationData.getAssignedAgentId();
        this.mStartTimestamp = dialogData.creationTs;
        this.mEndTimestamp = dialogData.endTs;
        this.mUnreadMessages = conversationData.unreadMessages;
    }

    public Participants getParticipants() {
        return this.mParticipants;
    }

    public String getConversationId() {
        return this.mConversationId;
    }

    public String getTargetId() {
        return this.mTargetId;
    }

    public String getBrandId() {
        return this.mBrandId;
    }

    protected void setBrandId(String brandId) {
        this.mBrandId = brandId;
    }

    public DialogState getState() {
        return this.mState;
    }

    public void setState(DialogState state) {
        if (this.mState != state) {
            LPLog.INSTANCE.d(TAG, FlowTags.DIALOGS, "Changing state from '" + (Object)((Object)this.mState) + "' to '" + (Object)((Object)state) + "' of dialog: " + this.mDialogId);
        }
        this.mState = state;
    }

    public long getRequestId() {
        return this.mRequestId;
    }

    public void setRequestId(long requestId) {
        this.mRequestId = requestId;
    }

    public String getAssignedAgentId() {
        return this.mAssignedAgentId;
    }

    public void setConversationId(String conversationId) {
        this.mConversationId = conversationId;
    }

    public void setDialogId(String dialogId) {
        this.mDialogId = dialogId;
    }

    public void setAssignedAgentId(String assignedAgentServerId) {
        this.mAssignedAgentId = assignedAgentServerId;
    }

    public int getLastServerSequence() {
        return this.mLastServerSequence;
    }

    public void setLastServerSequence(int lastServerSequence) {
        if (lastServerSequence > this.mLastServerSequence) {
            this.mLastServerSequence = lastServerSequence;
        }
    }

    public TTRType getConversationTTRType() {
        return this.mConversationTTRType;
    }

    public void setConversationTTRType(TTRType conversationTTRType) {
        LPLog.INSTANCE.d(TAG, "Setting conversation ttr type: " + (Object)((Object)conversationTTRType));
        this.mConversationTTRType = conversationTTRType;
    }

    public TTRManager getTTRManager() {
        return this.mTTRManager;
    }

    public CSAT.CSAT_SHOW_STATUS isShowedCSAT() {
        LPLog.INSTANCE.d(TAG, "isShowedCSAT:" + (Object)((Object)this.mShowedCSAT));
        return this.mShowedCSAT;
    }

    public void setShowedCSAT(CSAT.CSAT_SHOW_STATUS showedCSAT) {
        LPLog.INSTANCE.d(TAG, "setShowedCSAT:" + (Object)((Object)showedCSAT));
        this.mShowedCSAT = showedCSAT;
    }

    public CloseReason getCloseReason() {
        return this.mCloseReason;
    }

    public void setCloseReason(CloseReason mCloseReason) {
        this.mCloseReason = mCloseReason;
    }

    public long getEndTimestamp() {
        return this.mEndTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.mEndTimestamp = endTimestamp;
    }

    public long getStartTimestamp() {
        return this.mStartTimestamp;
    }

    public int getUnreadMessages() {
        return this.mUnreadMessages;
    }

    public void setUnreadMessages(int unreadMessages) {
        this.mUnreadMessages = unreadMessages;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.mStartTimestamp = startTimestamp;
    }

    public int getUpdateInProgress() {
        return this.mUpdateInProgress;
    }

    public void setUpdateInProgress(int mUpdateInProgress) {
        this.mUpdateInProgress = mUpdateInProgress;
    }

    public PendingDialogData getPendingData() {
        return this.mPendingDialogData;
    }

    public void setDialogType(DialogType dialogType) {
        this.mDialogType = dialogType;
    }

    public MultiDialog.ChannelType getChannelType() {
        return this.mChannelType;
    }

    public void setChannelType(MultiDialog.ChannelType channelType) {
        this.mChannelType = channelType;
    }

    public DialogType getDialogType() {
        return this.mDialogType;
    }

    public String getDialogId() {
        return this.mDialogId;
    }

    public boolean isOpen() {
        return this.mState == DialogState.OPEN;
    }

    public boolean isClosed() {
        return this.mState == DialogState.CLOSE;
    }

    public String toString() {
        return "Dialog: {conversationId: " + this.mConversationId + ", dialogId: " + this.mDialogId + ", state: " + (Object)((Object)this.mState) + ", type: " + (Object)((Object)this.mDialogType) + "}";
    }

    public boolean equals(Object obj) {
        return obj instanceof Dialog && ((Dialog)obj).getDialogId().equals(this.getDialogId()) || super.equals(obj);
    }

    public boolean isOpenOrPending() {
        return this.mState == DialogState.OPEN || this.mState == DialogState.PENDING;
    }
}

