/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.json.JSONObject;

public class TokenUtils {
    private static final String TAG = "TokenUtils";
    private static int jwtExpirationBuffer = -1;

    public static boolean isJwtExpired(String jwt) {
        if (jwtExpirationBuffer != -1) {
            jwtExpirationBuffer = Configuration.getInteger((int)R.integer.lp_messaging_buffer_expiration_seconds);
        }
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return false;
        }
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "jwt exists: " + LPLog.INSTANCE.mask((Object)jwt) + " checking if expired..");
        String[] segments = jwt.split("\\.");
        if (segments.length < 3) {
            return false;
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            String secondSegments = new String(secondSegmentsByte, StandardCharsets.UTF_8);
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            long expirationInSeconds = secondSegmentsJson.getLong("exp");
            long iat = secondSegmentsJson.getLong("iat");
            long expirationInMillis = expirationInSeconds * 1000L;
            LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "expiration = " + new Date(expirationInMillis).toString());
            LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "iat = " + new Date(iat * 1000L).toString());
            if (TokenUtils.isGoingToExpire(expirationInMillis)) {
                LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "JWT is expired or about to.. ");
                return true;
            }
            LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "JWT is still valid ");
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Exception while checking if JWT is expired.", (Throwable)e);
        }
        return false;
    }

    private static boolean isGoingToExpire(long expirationInMillis) {
        long bufferTime = jwtExpirationBuffer * 1000;
        long time = System.currentTimeMillis() + bufferTime;
        return time > expirationInMillis;
    }

    public static String getOriginalConsumerIdFromJWT(String jwt) {
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return "";
        }
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "Getting original consumerId from jwt: " + LPLog.INSTANCE.mask((Object)jwt));
        String[] segments = jwt.split("\\.");
        if (segments.length < 3) {
            return "";
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            String secondSegments = new String(secondSegmentsByte, StandardCharsets.UTF_8);
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            JSONObject lpExt = secondSegmentsJson.optJSONObject("lp.ext");
            if (lpExt != null) {
                return lpExt.optString("sub");
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Exception while getting original consumer ID from JWT.", (Throwable)e);
        }
        return "";
    }

    public static String getConsumerUserId(String jwt) {
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return "";
        }
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "Getting original consumerId from jwt: " + LPLog.INSTANCE.mask((Object)jwt));
        String[] segments = jwt.split("\\.");
        if (segments.length < 3) {
            return "";
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            String secondSegments = new String(secondSegmentsByte, StandardCharsets.UTF_8);
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            return secondSegmentsJson.optString("sub");
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Exception while getting Consumer User ID.", (Throwable)e);
            return "";
        }
    }
}

