package com.liveperson.api.response.model;

import com.liveperson.api.exception.BadConversationException;
import com.liveperson.messaging.model.AmsDialogs;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;

/**
 * Created by oferd on 8/10/15.
 */
public class ConversationUMSDetails extends ConversationHistoryDetails {
    private long metaDataLastUpdateTs;
    public Ttr ttr;
    public Delay delay;
    public long manualETTR;

    public ConversationUMSDetails(JSONObject jsonObject, String conversationId) throws JSONException, BadConversationException {
        super(jsonObject, conversationId);
        metaDataLastUpdateTs = jsonObject.optLong("metaDataLastUpdateTs", -1);

        AmsDialogs.setIsUmsSupportingDialogs(stage != null);

        //******** TTR *********//
        ttr = null;
        JSONObject ttrObj = jsonObject.optJSONObject("ttr");
        if (ttrObj != null) {
            ttr = new Ttr(ttrObj);
        }
        //******** Delay *********//
        delay = null;
        JSONObject delayObj = jsonObject.optJSONObject("delay");
        if (delayObj != null) {
            delay = new Delay(delayObj);
        }

        //******** Participants *********//

        manualETTR = jsonObject.optLong("manualETTR", -1);
    }

    @Override
    public String toString() {
        return Arrays.toString(dialogs);
    }
}