package com.liveperson.messaging.controller.connection.connectionevents;

import com.liveperson.infra.statemachine.BaseEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.controller.connection.BaseConnectionState;

/**
 * Created by shiranr on 13/03/2016.
 */
public class TaskFailedEvent extends BaseEvent {

    private final String mTaskName;
    private final TaskType type;
    private final Exception exception;

    public TaskFailedEvent(String taskName, TaskType type, Exception exception) {
        super("TaskFailedEvent");
        mTaskName = taskName;
        this.type = type;
        this.exception = exception;
    }

    @Override
    public void accept(IState state) {
        ((BaseConnectionState) state).visit(this);
    }

    public TaskType getType() {
        return type;
    }

    public Exception getException() {
        return exception;
    }

    public String getTaskName() {
        return mTaskName;
    }

}