package com.liveperson.messaging.utils;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.background.filesharing.FileSharingType;

import static com.liveperson.infra.errors.ErrorCode.ERR_000000B8;

public class FileSharingUtils {

    private static final String TAG = "FileSharingUtils";

    /**
     * return file type based on file uri
     * @param uri
     * @return
     */
    @NonNull
    public static FileSharingType getFileSharingTypeFromUri(String uri, Context context) {
        try {
            Uri fileUri = Uri.parse(uri);
            String mimeType = context.getContentResolver().getType(fileUri);
            String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (extension != null) {
                return FileSharingType.getFileTypeFromExtension(extension);
            } else {
                return FileSharingType.UNKNOWN;
            }
        } catch (Exception e) {
	        LPLog.INSTANCE.e(TAG, ERR_000000B8, "Failed to get file sharing type.", e);
            return FileSharingType.UNKNOWN;
        }
    }

    /**
     * return true if document type: docx, pptx, xlsx, pdf
     * @param fileType
     * @return
     */
    public static boolean isDocumentType(FileSharingType fileType) {
        return fileType != null && fileType.getCommonFileType() == FileSharingType.CommonFileType.DOCUMENT;
    }
}
