/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.support.annotation.NonNull;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.commands.SendMessageCommand;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.http.RestRequestParams;
import com.liveperson.messaging.network.http.SendFileRequestRest;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import com.liveperson.messaging.network.socket.requests.SendFileRequest;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;

public abstract class SendFileCommand
extends SendMessageCommand {
    private static final String TAG = "SendFileCommand";
    private final String mFileContentType;
    private final String mFileTypeExtension;
    private String mThumbnailPath;
    private String mLocalFilePath;
    protected String mCaption;
    private String mRelativePath;
    private String mFileType;
    protected String mPreview;
    protected SendFileCommandListener mCallback;
    protected long mMessageRowId = -1L;
    private boolean sendViaRest;
    private RestRequestParams restDomain;

    protected abstract MessagingChatMessage.MessageType getMessageType(MaskedMessage var1);

    public SendFileCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message) {
        super(controller, targetId, brandId, message);
        this.mFileContentType = contentType;
        this.mThumbnailPath = thumbnailPath;
        this.mLocalFilePath = filePath;
        this.mMessage = message;
        this.mCaption = this.mMessage.getServerMessage();
        this.mFileTypeExtension = fileTypeExtension;
    }

    public void setCallback(SendFileCommandListener mCallback) {
        this.mCallback = mCallback;
    }

    public void setFileDetails(String relativePath, String fileType, String previewBase64) {
        this.mRelativePath = relativePath;
        this.mFileType = fileType;
        this.mPreview = "data:" + this.mFileContentType + ";base64," + previewBase64;
    }

    public void addMessageToDB() {
        try {
            LPLog.INSTANCE.d(TAG, "addMessageToDB");
            String newDialogId = this.updateMessageWithCurrentDialog();
            LPLog.INSTANCE.d(TAG, "addMessageToDB File! - dialogId = " + newDialogId);
            this.addMessageToDBAndSend(newDialogId, this.mMessage);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000AA, "Exception while adding message to database or sending it.", (Throwable)e);
        }
    }

    private String updateMessageWithCurrentDialog() {
        String newDialogId;
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        if (dialog == null) {
            LPLog.INSTANCE.i(TAG, "updateMessageWithCurrentDialog: creating new temp dialog and conversation, there is no open one.");
            newDialogId = "TEMP_DIALOG";
            this.createQueuedConversationAndDialog();
        } else {
            switch (dialog.getState()) {
                case CLOSE: {
                    LPLog.INSTANCE.i(TAG, "updateMessageWithCurrentDialog: creating new temp dialog and conversation, they are closed.");
                    newDialogId = "TEMP_DIALOG";
                    BaseAMSSocketRequest newConversationRequest = this.createPendingConversationAndDialog();
                    this.sendCreateConversationRequest(newConversationRequest);
                    break;
                }
                default: {
                    newDialogId = dialog.getDialogId();
                    LPLog.INSTANCE.i(TAG, "updateMessageWithCurrentDialog: getting current dialog ID: " + newDialogId + ", state: " + (Object)((Object)dialog.getState()));
                }
            }
        }
        return newDialogId;
    }

    @Override
    protected void addMessageToDBAndSend(String dialogId, MaskedMessage message) {
        this.mEventId = UniqueID.createUniqueMessageEventId();
        LPLog.INSTANCE.d(TAG, "addMessageToDBAndSend, createNewChatMessage, ContentType: " + this.mFileContentType);
        MessagingChatMessage chatMessage = this.createNewChatMessage(dialogId, message);
        chatMessage.setContentType(this.mFileContentType);
        this.mController.amsMessages.addMessage(chatMessage, true).setPostQueryOnBackground(rowId -> {
            if (rowId == -1L) {
                LPLog.INSTANCE.d(TAG, "onResult: message was updated on DB (and not inserted). No need to add the file to DB");
            } else {
                LPLog.INSTANCE.d(TAG, "addMessageToDBAndSend,  MessagingChatMessage was added. row id: " + rowId + ". Adding fileMessage to db.");
                FileMessage fileMessage = new FileMessage(this.mThumbnailPath, this.mFileTypeExtension, this.mLocalFilePath, null, (long)rowId);
                long fileRowId = (Long)MessagingFactory.getInstance().getController().amsFiles.addFile((long)rowId, fileMessage).executeSynchronously();
                this.mMessageRowId = rowId;
                LPLog.INSTANCE.d(TAG, "addMessageToDBAndSend, fileMessage was added to db. Thumbnail path: " + this.mThumbnailPath + ", local file path: " + this.mLocalFilePath);
                this.mController.amsMessages.updateFileMessageByRowId((long)rowId, fileRowId).executeSynchronously();
                if (this.mCallback != null) {
                    this.mCallback.onFileAddedToDB(this.mMessageRowId, fileRowId);
                }
            }
        }).execute();
        if (this.mMessage.isMasked()) {
            MessagingChatMessage warning = new MessagingChatMessage(chatMessage.getOriginatorId(), message.getMaskedSystemMessage(), chatMessage.getTimeStamp() + 1L, chatMessage.getDialogId(), UniqueID.createUniqueMessageEventId(), MessagingChatMessage.MessageType.SYSTEM_MASKED, MessagingChatMessage.MessageState.RECEIVED, -3, ContentType.text_plain.getText(), EncryptionVersion.NONE);
            this.mController.amsMessages.addMessage(warning, true).execute();
        }
    }

    public void updateMessageConversationId() {
        LPLog.INSTANCE.i(TAG, "update Message dialog ID");
        String newDialogId = this.updateMessageWithCurrentDialog();
        LPLog.INSTANCE.i(TAG, "update Message dialog ID - updating file message: " + this.mMessageRowId + " with new dialog id = " + newDialogId);
        this.mController.amsMessages.updateMessageDialogServerIdAndTime(this.mMessageRowId, newDialogId).setPostQueryOnBackground(data -> {
            LPLog.INSTANCE.i(TAG, "Finished updating file message ( dialog ID and new time ) ");
            if (this.mCallback != null) {
                this.mCallback.onMessageUpdatedInDB();
            }
        }).execute();
    }

    @Override
    public void execute() {
        LPLog.INSTANCE.i(TAG, "Sending file message. creating new conversation if there is no open one.");
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        if (dialog == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000AF, "SHOULD NEVER HAPPEN!!");
            this.addMessageToDBAndSend("TEMP_DIALOG", this.mMessage);
            BaseAMSSocketRequest newConversationRequest = this.createPendingConversationAndDialog();
            this.sendCreateConversationRequest(newConversationRequest);
        } else {
            LPLog.INSTANCE.i(TAG, "checking current dialog, state - " + (Object)((Object)dialog.getState()));
            switch (dialog.getState()) {
                case CLOSE: {
                    LPLog.INSTANCE.i(TAG, "Dialog is closed. Fail the file message");
                    this.markMessageAsError();
                    break;
                }
                case QUEUED: {
                    LPLog.INSTANCE.i(TAG, "Dialog is queued and waiting to be created...");
                    this.markMessageAsPending();
                    this.sendNewConversationRequest(dialog.getConversationId(), dialog.getDialogId(), dialog.getRequestId());
                    break;
                }
                case OPEN: 
                case PENDING: {
                    LPLog.INSTANCE.i(TAG, "Dialog is open/pending. Sending message");
                    this.markMessageAsPending();
                }
            }
        }
        this.sendMessageIfDialogIsOpen();
    }

    private void markMessageAsPending() {
        LPLog.INSTANCE.i(TAG, "Changing message state to pending.. waiting to be send...");
        this.mController.amsMessages.updateMessageState(this.mMessageRowId, MessagingChatMessage.MessageState.PENDING);
    }

    private void markMessageAsError() {
        LPLog.INSTANCE.i(TAG, "Changing message state to Error.");
        this.mController.amsMessages.updateMessageState(this.mMessageRowId, MessagingChatMessage.MessageState.ERROR);
    }

    private void sendNewConversationRequest(String newConversationId, String newDialogId, long requestId) {
        LPLog.INSTANCE.i(TAG, "Sending request to create new conversation. conversation id = " + newConversationId);
        NewConversationRequest newConversationRequest = this.createNewConversationRequest(newConversationId, newDialogId, requestId);
        this.mController.amsConversations.updateConversationState(this.mTargetId, newConversationId, ConversationState.PENDING);
        this.mController.amsDialogs.updateDialogState(newDialogId, DialogState.PENDING);
        SocketManager.getInstance().send((BaseSocketRequest)newConversationRequest);
    }

    private void createQueuedConversationAndDialog() {
        long requestId = BaseSocketRequest.createRequestId();
        this.createQueuedConversation(requestId);
        this.createQueuedDialog(requestId);
    }

    private void createQueuedConversation(long requestId) {
        this.mController.amsConversations.createQueuedConversation(this.mTargetId, this.mBrandId, requestId);
    }

    private void createQueuedDialog(long requestId) {
        this.mController.amsDialogs.createQueuedDialog(this.mTargetId, this.mBrandId, requestId);
    }

    @Override
    @NonNull
    protected MessagingChatMessage createNewChatMessage(String dialogId, MaskedMessage message) {
        return new MessagingChatMessage(this.mController.getOriginatorId(this.mTargetId), message.getDbMessage(), System.currentTimeMillis(), dialogId, this.mEventId, this.getMessageType(message), MessagingChatMessage.MessageState.QUEUED, EncryptionVersion.NONE);
    }

    @Override
    @NonNull
    protected SendMessageRequest createMessageRequest(Messaging mController, String eventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
        SendFileRequest sendFileRequest = new SendFileRequest(mController, eventId, mTargetId, mBrandId, dialogId, conversationId);
        sendFileRequest.setFileContent(this.mCaption, this.mRelativePath, this.mFileType, this.mPreview);
        return sendFileRequest;
    }

    @Override
    protected void sendMessage(String conversationServerId, SendMessageRequest sendMessageRequest) {
        if (this.sendViaRest) {
            new SendFileRequestRest(this.restDomain, sendMessageRequest).execute();
        } else {
            super.sendMessage(conversationServerId, sendMessageRequest);
        }
    }

    public void failMessage() {
        Dialog dialog;
        Conversation conversation;
        LPLog.INSTANCE.w(TAG, "failMessage: upload file failed");
        if (this.mMessageRowId != -1L) {
            LPLog.INSTANCE.d(TAG, "failMessage: setting message (rowId: " + this.mMessageRowId + ") to error");
            this.mController.amsMessages.updateMessageState(this.mMessageRowId, MessagingChatMessage.MessageState.ERROR);
        }
        if ((conversation = this.mController.amsConversations.getConversation(this.mTargetId)).getState() == ConversationState.QUEUED) {
            LPLog.INSTANCE.d(TAG, "failMessage: conversation " + conversation.getConversationId() + " is queued. Close it");
            ConversationData conversationData = new ConversationData();
            conversationData.conversationId = "TEMP_CONVERSATION";
            conversationData.brandId = this.mBrandId;
            conversationData.targetId = this.mTargetId;
            this.mController.amsConversations.updateClosedConversation(conversationData, false).execute();
        }
        if ((dialog = this.mController.amsDialogs.getActiveDialog()) != null && dialog.getState() == DialogState.QUEUED) {
            ConversationData conversationData = new ConversationData();
            conversationData.conversationId = "TEMP_CONVERSATION";
            conversationData.brandId = this.mBrandId;
            conversationData.targetId = this.mTargetId;
            this.mController.amsDialogs.updateClosedDialog(conversationData, dialog, false).execute();
        }
    }

    public void setSendViaRest(boolean sendViaRest, RestRequestParams restDomain) {
        this.sendViaRest = sendViaRest;
        this.restDomain = restDomain;
    }

    public static interface SendFileCommandListener {
        public void onFileAddedToDB(long var1, long var3);

        public void onMessageUpdatedInDB();
    }
}

