/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.UnregisterPushRequest;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.List;

public class UnregisterPusherCommand
implements Command {
    private static final String TAG = "UnregisterPusherCommand";
    private static final String PUSHER_UNREGISTER_URL = "https://%s/api/account/%s/device/unregister?v=2.0";
    private static final String UN_AUTH_PUSHER_UNREGISTER_URL = "https://%s/api/account/%s/device/unregister";
    private static final int MAX_RETRY_NUMBER = 3;
    private final AccountsController mAccountsController;
    private final AmsUsers mAmsUsers;
    private String mBrandId;
    private String mAppId;
    private String pusherURL;
    private String consumerId;
    @Nullable
    private ICallback<Void, Exception> listener;
    private boolean isFullLogout;
    private int logoutRetry;
    private ICallback<Void, Exception> requestCallback = new ICallback<Void, Exception>(){

        public void onSuccess(Void value) {
            PreferenceManager.getInstance().setBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", UnregisterPusherCommand.this.mBrandId, false);
            PreferenceManager.getInstance().remove("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", UnregisterPusherCommand.this.mBrandId);
            if (UnregisterPusherCommand.this.listener != null) {
                UnregisterPusherCommand.this.listener.onSuccess((Object)value);
            }
        }

        public void onError(Exception exception) {
            if (UnregisterPusherCommand.this.isFullLogout && UnregisterPusherCommand.this.logoutRetry < 3) {
                UnregisterPusherCommand.this.logoutRetry++;
                LPLog.INSTANCE.w(UnregisterPusherCommand.TAG, "Unregister pusher retry #: " + UnregisterPusherCommand.this.logoutRetry, (Throwable)exception);
                UnregisterPusherCommand.this.runUnregisterPush();
            } else {
                LPLog.INSTANCE.e(UnregisterPusherCommand.TAG, ErrorCode.ERR_00000148, "Failed to unregister pusher", (Throwable)exception);
                if (UnregisterPusherCommand.this.listener != null) {
                    UnregisterPusherCommand.this.listener.onError((Throwable)exception);
                }
            }
        }
    };

    public UnregisterPusherCommand(AccountsController accountsController, AmsUsers amsUsers, String brandId, String consumerId) {
        this(accountsController, amsUsers, brandId, "", null, false);
        this.consumerId = consumerId;
    }

    public UnregisterPusherCommand(AccountsController accountsController, AmsUsers amsUsers, String brandId, String appId, @Nullable ICallback<Void, Exception> listener, boolean isFullLogout) {
        this.mAccountsController = accountsController;
        this.mAmsUsers = amsUsers;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.listener = listener;
        this.isFullLogout = isFullLogout;
        this.logoutRetry = 0;
    }

    public void execute() {
        if (!PreferenceManager.getInstance().getBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", this.mBrandId, false)) {
            this.notifySuccess();
            return;
        }
        LPLog.INSTANCE.i(TAG, "execute unregister for brandId " + this.mBrandId);
        String pusherDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "pusher");
        if (TextUtils.isEmpty((CharSequence)pusherDomain) && TextUtils.isEmpty((CharSequence)(pusherDomain = PreferenceManager.getInstance().getStringValue("pusher", this.mBrandId, null)))) {
            LPLog.INSTANCE.w(TAG, "pusherDomain does not exists. Quit unregister push");
            this.notifySuccess();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mAppId) && !TextUtils.isEmpty((CharSequence)this.consumerId)) {
            this.mAppId = PreferenceManager.getInstance().getStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, "");
            PreferenceManager.getInstance().setStringValue("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", this.mBrandId, this.consumerId);
        } else {
            PreferenceManager.getInstance().setStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, this.mAppId);
        }
        this.pusherURL = this.isFullLogout && this.mAccountsController.getAccount(this.mBrandId) != null && !this.mAccountsController.getAccount(this.mBrandId).isAuthenticated() ? String.format(UN_AUTH_PUSHER_UNREGISTER_URL, pusherDomain, this.mBrandId) : String.format(PUSHER_UNREGISTER_URL, pusherDomain, this.mBrandId);
        if (TextUtils.isEmpty((CharSequence)this.consumerId)) {
            this.consumerId = this.mAmsUsers.getConsumerId(this.mBrandId);
        }
        if (TextUtils.isEmpty((CharSequence)this.consumerId)) {
            LPLog.INSTANCE.d(TAG, "execute: consumerId is not available. Trying to get from DB...");
            this.mAmsUsers.getConsumerByBrandIDFromDB(this.mBrandId).setPostQueryOnBackground(dbConsumerId -> {
                if (!TextUtils.isEmpty((CharSequence)dbConsumerId)) {
                    this.consumerId = dbConsumerId;
                    this.runUnregisterPush();
                    LPLog.INSTANCE.d(TAG, "onResult: got  consumerId from DB (" + dbConsumerId + "). Unregister push with it...");
                } else {
                    LPLog.INSTANCE.w(TAG, "onResult: Cannot get user profile from DB. Quit unregister push");
                    if (this.listener != null && this.isFullLogout) {
                        this.listener.onSuccess(null);
                    }
                }
            }).execute();
        } else {
            this.runUnregisterPush();
        }
    }

    private void notifySuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(null);
        }
    }

    private void runUnregisterPush() {
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        if (this.isFullLogout) {
            LPLog.INSTANCE.d(TAG, "run: Unregister push immediately");
            if (InternetConnectionService.isNetworkAvailable()) {
                new UnregisterPushRequest(this.pusherURL, this.consumerId, this.mAppId, certificates).setCallback(this.requestCallback).execute();
            } else if (this.listener != null) {
                this.listener.onError((Throwable)new Exception("No network available"));
            }
        } else {
            new SynchronizedInternetConnectionCallback(() -> {
                LPLog.INSTANCE.d(TAG, "run: Unregister push for consumerId: " + LPLog.INSTANCE.mask((Object)this.consumerId));
                new UnregisterPushRequest(this.pusherURL, this.consumerId, this.mAppId, certificates).setCallback(this.requestCallback).execute();
            }).execute();
        }
    }
}

