/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.network.http.IdpRequest;
import com.liveperson.messaging.network.http.UnAuthRequest;
import com.liveperson.messaging.utils.TokenUtils;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public class IdpTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "IdpTask";
    private static final String KEY_CONSUMER_ID = "KEY_CONSUMER_ID";
    private final AmsUsers mAmsUsers;
    private AccountsController mAccountsController;
    private String mHostVersion;

    public IdpTask(AccountsController accountsController, AmsUsers amsUsers, String hostVersion) {
        this.mHostVersion = hostVersion;
        this.mAccountsController = accountsController;
        this.mAmsUsers = amsUsers;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running IDP task...");
        AmsConnectionAnalytics.idpTaskStart();
        String token = this.mAccountsController.getToken(this.mBrandId);
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        boolean tokenExpired = this.mAccountsController.isTokenExpired(this.mBrandId);
        LPAuthenticationParams auth = this.mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (!TextUtils.isEmpty((CharSequence)token) && !tokenExpired) {
            LPLog.INSTANCE.d(TAG, "execute - token exists and valid: " + LPLog.INSTANCE.mask((Object)token));
            AmsConnectionAnalytics.idpTaskEnd();
            this.mCallback.onTaskSuccess();
        } else {
            String idpDomain = this.getIdpDomain();
            if (auth.getAuthType() == LPAuthenticationType.UN_AUTH) {
                if (tokenExpired) {
                    this.mAccountsController.setToken(this.mBrandId, null);
                }
                String connectorId = this.mAccountsController.getAccount(this.mBrandId).getConnectorId();
                new UnAuthRequest(this.mAccountsController.getAccount(this.mBrandId), idpDomain, this.mBrandId, auth, this.mHostVersion, this.getIdpCallback(), certificates, connectorId).execute();
            } else {
                new IdpRequest(this.mAccountsController.getAccount(this.mBrandId), idpDomain, this.mBrandId, auth, this.mHostVersion, this.getIdpCallback(), certificates).execute();
            }
        }
    }

    @NonNull
    private IDPExceptionICallback getIdpCallback() {
        return new IDPExceptionICallback();
    }

    private String getIdpDomain() {
        String idpDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "idp");
        if (TextUtils.isEmpty((CharSequence)idpDomain)) {
            String asyncMessagingEnt = this.mAccountsController.getServiceUrl(this.mBrandId, "asyncMessagingEnt");
            idpDomain = asyncMessagingEnt.replaceFirst("msg", "idp");
        }
        return idpDomain;
    }

    @Override
    public String getName() {
        return TAG;
    }

    public class IDPExceptionICallback
    implements ICallback<String, Exception> {
        public void onSuccess(String token) {
            LPLog.INSTANCE.d(IdpTask.TAG, "onSuccess: got token ");
            IdpTask.this.mAccountsController.setToken(IdpTask.this.mBrandId, token);
            IdpTask.this.mAccountsController.getAccount(IdpTask.this.mBrandId).setOriginalConsumerId(TokenUtils.getOriginalConsumerIdFromJWT(token));
            IdpTask.this.mAmsUsers.updateConsumerId(IdpTask.this.mBrandId, TokenUtils.getConsumerUserId(token));
            AmsConnectionAnalytics.idpTaskEnd();
            IdpTask.this.mAccountsController.getAccount(IdpTask.this.mBrandId).sendAuthenticationCompletedStatus();
            IdpTask.this.mCallback.onTaskSuccess();
        }

        private void switchUser(String token) {
            String consumerId = TokenUtils.getConsumerUserId(token);
            boolean shouldRegisterPusher = false;
            if (PreferenceManager.getInstance().contains(IdpTask.KEY_CONSUMER_ID, IdpTask.this.mBrandId) && !PreferenceManager.getInstance().getStringValue(IdpTask.KEY_CONSUMER_ID, IdpTask.this.mBrandId, "").equals(consumerId)) {
                LPLog.INSTANCE.i(IdpTask.TAG, "New user login. Performing lite logout.");
                String oldConsumerId = PreferenceManager.getInstance().getStringValue(IdpTask.KEY_CONSUMER_ID, IdpTask.this.mBrandId, "");
                shouldRegisterPusher = true;
                MessagingFactory.getInstance().getController().liteLogout(IdpTask.this.mBrandId, oldConsumerId, consumerId);
            } else {
                LPLog.INSTANCE.i(IdpTask.TAG, "Old user login.");
            }
            PreferenceManager.getInstance().setStringValue(IdpTask.KEY_CONSUMER_ID, IdpTask.this.mBrandId, consumerId);
            IdpTask.this.mAccountsController.setToken(IdpTask.this.mBrandId, token);
            IdpTask.this.mAccountsController.getAccount(IdpTask.this.mBrandId).setOriginalConsumerId(TokenUtils.getOriginalConsumerIdFromJWT(token));
            IdpTask.this.mAmsUsers.updateConsumerId(IdpTask.this.mBrandId, consumerId);
            AmsConnectionAnalytics.idpTaskEnd();
            IdpTask.this.mAccountsController.getAccount(IdpTask.this.mBrandId).sendAuthenticationCompletedStatus();
            IdpTask.this.mCallback.onTaskSuccess();
            if (shouldRegisterPusher) {
                MessagingFactory.getInstance().getController().registerPusherOnLiteLogout(IdpTask.this.mBrandId, IdpTask.this.mAccountsController.getLPAuthenticationParams(IdpTask.this.mBrandId));
            }
        }

        public void onError(Exception exception) {
            LPLog.INSTANCE.d(IdpTask.TAG, "onError: failed to connect to idp!", (Throwable)exception);
            if (exception instanceof SSLPeerUnverifiedException) {
                IdpTask.this.mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, exception);
            } else {
                IdpTask.this.mCallback.onTaskError(TaskType.IDP, exception);
            }
        }

        public void onError(TaskType taskType, Exception exception) {
            LPLog.INSTANCE.d(IdpTask.TAG, "onError: failed to connect to idp! taskType = " + (Object)((Object)taskType) + ", error: ", (Throwable)exception);
            IdpTask.this.mCallback.onTaskError(taskType, exception);
        }
    }
}

