/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.utils.TokenUtils;

public class SynchronizedAuthenticationCompletedCallback
implements Command {
    private static final String TAG = "SynchronizedAuthenticationCompletedCallback";
    private static final String ERROR_UNABLE_TO_MAKE_REQUEST = "Unable to make request.";
    private final AccountsController mAccountController;
    private String mBrandId;
    private boolean handled = false;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;
    private PreferenceManager mPreferenceManager;
    private ICallback<Void, Exception> mCallback;

    public SynchronizedAuthenticationCompletedCallback(AccountsController accountsController, String brandId, ICallback<Void, Exception> callback) {
        this.mAccountController = accountsController;
        this.mBrandId = brandId;
        this.mCallback = callback;
        this.mPreferenceManager = PreferenceManager.getInstance();
    }

    public void execute() {
        this.executeWithReturnValue();
    }

    public boolean executeWithReturnValue() {
        if (this.isValidAuthentication()) {
            this.handleConnection();
            return true;
        }
        this.registerToConnectionStateChanges();
        this.validateStatusDidNotChangedDuringRegistration();
        return false;
    }

    private boolean isValidAuthentication() {
        if (this.mAccountController.getAccount(this.mBrandId) == null) {
            String localToken = this.getTokenFromSharedPreferences();
            if (TokenUtils.isJwtExpired(localToken)) {
                return false;
            }
            if (localToken != null) {
                return true;
            }
        }
        return this.mAccountController.getAccount(this.mBrandId) != null && this.mAccountController.getAccount(this.mBrandId).isAuthenticatedCompleted() && !this.mAccountController.getAccount(this.mBrandId).isTokenExpired();
    }

    private String getTokenFromSharedPreferences() {
        String token;
        String decryptedToken = this.mPreferenceManager.getStringValue("account_token_enc", this.mBrandId, null);
        if (TextUtils.isEmpty((CharSequence)decryptedToken)) {
            token = this.mPreferenceManager.getStringValue("account_token", this.mBrandId, null);
            this.mPreferenceManager.remove("account_token", this.mBrandId);
        } else {
            token = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedToken);
        }
        return token;
    }

    private void registerToConnectionStateChanges() {
        try {
            if (this.mLocalBroadcastReceiver == null) {
                this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_KEY_AUTH_COMPLETED_ACTION").addAction("BROADCAST_CONNECTING_TO_SERVER_ERROR").addAction("BROADCAST_AMS_TOKEN_EXPIRED").build((context, intent) -> {
                    if ("BROADCAST_KEY_AUTH_COMPLETED_ACTION".equals(intent.getAction())) {
                        this.handleConnection();
                    } else if ("BROADCAST_CONNECTING_TO_SERVER_ERROR".equals(intent.getAction())) {
                        this.handleError("Error: Failed to connect to the server");
                    } else if ("BROADCAST_AMS_TOKEN_EXPIRED".equals(intent.getAction())) {
                        this.handleError("Error: Token expired, refresh the token and try again");
                    }
                });
            }
            this.mLocalBroadcastReceiver.register();
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000D3, "registerToConnectionStateChanges: Failed to register", (Throwable)error);
        }
    }

    private synchronized void validateStatusDidNotChangedDuringRegistration() {
        if (!this.handled && this.isValidAuthentication()) {
            this.handleConnection();
        }
    }

    private synchronized void handleConnection() {
        if (this.handled) {
            return;
        }
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
        }
        this.handled = true;
        this.mCallback.onSuccess(null);
    }

    private synchronized void handleError(String error) {
        if (this.handled) {
            return;
        }
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
        }
        this.handled = true;
        this.mCallback.onError((Throwable)new Exception("Unable to make request. " + error));
    }
}

