/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.parsers;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.ButtonElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.ImageElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.MapElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.TextElement;
import com.liveperson.messaging.structuredcontent.model.elements.complex.CarouselElement;
import com.liveperson.messaging.structuredcontent.model.elements.complex.LayoutElement;
import com.liveperson.messaging.structuredcontent.model.elements.complex.QuickRepliesElement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ElementParser {
    private static final String TAG = "ElementParser";

    public static SimpleElement parse(JSONObject jsonObject) {
        SimpleElement elementToAdd;
        try {
            String type;
            switch (type = jsonObject.getString("type")) {
                case "vertical": {
                    elementToAdd = new LayoutElement(jsonObject);
                    break;
                }
                case "horizontal": {
                    elementToAdd = new LayoutElement(jsonObject);
                    break;
                }
                case "text": {
                    elementToAdd = new TextElement(jsonObject);
                    break;
                }
                case "button": {
                    elementToAdd = new ButtonElement(jsonObject);
                    break;
                }
                case "image": {
                    elementToAdd = new ImageElement(jsonObject);
                    break;
                }
                case "map": {
                    elementToAdd = new MapElement(jsonObject);
                    break;
                }
                case "carousel": {
                    elementToAdd = new CarouselElement(jsonObject);
                    break;
                }
                case "quickReplies": {
                    elementToAdd = new QuickRepliesElement(jsonObject);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "parse: Error parsing json. Either missing mandatory element or incorrect json. jsonObject: " + LPLog.INSTANCE.mask((Object)jsonObject), (Throwable)e);
            return null;
        }
        return elementToAdd;
    }

    public static boolean isStructuredContentEmpty(JSONObject jsonObject) {
        try {
            JSONArray elements;
            String type = jsonObject.getString("type");
            if (("vertical".equals(type) || "horizontal".equals(type)) && (elements = jsonObject.getJSONArray("elements")).length() == 0) {
                return true;
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "parse: Error parsing json. Either missing mandatory element or incorrect json. jsonObject: " + LPLog.INSTANCE.mask((Object)jsonObject), (Throwable)e);
        }
        return false;
    }
}

