package com.liveperson.api.request;

import com.liveperson.api.response.AbstractResponse;
import com.liveperson.api.response.BaseGenerateURLResponse;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by shiranr on 06/07/2016.
 */
public abstract class BaseGenerateURL extends AbstractRequest {
	private static final String BASE_GENERATE_URL_TYPE = "ms.GenerateURL";

	@Override
	protected String getMessageType() {
		return BASE_GENERATE_URL_TYPE;
	}

	@Override
	protected abstract void toJson(JSONObject json) throws JSONException;

	public static class Response extends AbstractResponse<BaseGenerateURLResponse> {

		public static final String BASE_GENERATE_URL_RESPONSE_TYPE = ".ams.ms.BaseGenerateURL$Response";

		BaseGenerateURLResponse body;

		public Response(JSONObject obj) throws JSONException {
			super(obj);
			body = new BaseGenerateURLResponse(obj.getJSONObject(JSON_KEY_BODY));
		}


		public BaseGenerateURLResponse getBody() {
			return body;
		}
	}

}

