package com.liveperson.api.request;

import android.text.TextUtils;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/9/2015.
 */
public class GenerateUploadTokenRequest extends BaseAMSSocketRequest<GeneratedUploadTokenField.Response, GenerateUploadTokenRequest> {

	private static final String TAG = "GenerateUploadTokenRequest";
	private String mDialogId, mFormId, mInvitationId;
	private ICallback<Object, Throwable> mCallback;

	public GenerateUploadTokenRequest(String socketUrl, String dialogId, String formId, String invitationId) {
		super(socketUrl);
		mDialogId = dialogId;
		mFormId = formId;
		mInvitationId = invitationId;
	}

	@Override
	protected String getData() {
		return new GeneratedUploadTokenField(
				mDialogId,
				mFormId,
				mInvitationId
		).toJsonString(getRequestId());
	}

	@Override
	protected String getRequestName() {
		return TAG;
	}

	public void setResponseCallBack(ICallback<Object, Throwable> callBack) {
		mCallback = callBack;
	}

	@Override
	protected BaseResponseHandler<GeneratedUploadTokenField.Response, GenerateUploadTokenRequest> getResponseHandler() {

		return new BaseResponseHandler<GeneratedUploadTokenField.Response, GenerateUploadTokenRequest>() {

			@Override
			public String getAPIResponseType() {
				return GeneratedUploadTokenField.Response.GENERATE_UPLOAD_RESPONSE_TYPE;
			}

			@Override
			public BaseResponseHandler getResponseByExpectedType(String expectedType) {
				BaseResponseHandler supportedResponseHandler = getSupportedResponseHandler(expectedType);
				if (supportedResponseHandler != null){
					return supportedResponseHandler;
				}
				return this;
			}


			@Override
			protected BaseResponseHandler getSupportedResponseHandler(String messageType) {
				if (TextUtils.equals(messageType, ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE)){
					return new BaseResponseHandler<ReqBody.StringResp, NewConversationRequest>() {

						@Override
						public String getAPIResponseType() {
							return ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE;
						}

						@Override
						protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
							return new ReqBody.StringResp(jsonObject);
						}

						@Override
						protected boolean handle(ReqBody.StringResp response) {
							LPLog.INSTANCE.d(TAG, "Received String response (" + response.code + ").");
							if (response.code > 201) {
								LPLog.INSTANCE.w(TAG, "Received bad response (" + response.code + ").");
								mCallback.onError(new Exception());
								return true;
							}
							return false;
						}
					};
				}
				return super.getSupportedResponseHandler(messageType);
			}

			@Override
			protected GeneratedUploadTokenField.Response parse(JSONObject jsonObject) throws JSONException {
				LPLog.INSTANCE.d(TAG, "Got resolve response: " + jsonObject.optString("code"));

				if (jsonObject.optString("code").equalsIgnoreCase("200")){
					return new GeneratedUploadTokenField.Response(jsonObject);
				}
				return null;
			}

			@Override
			protected boolean handle(GeneratedUploadTokenField.Response data) {
				//send update only when notification will arrive.
				LPLog.INSTANCE.d(TAG, "Got resolve response: " + LPLog.INSTANCE.mask(data.getBody()));
				mCallback.onSuccess(data.getBody());
				return true;
			}

			@Override
			protected void giveUp() {
				super.giveUp();
				LPLog.INSTANCE.d(TAG, "Giving up - socket closed");
				mCallback.onError(new Exception());
			}
		};

	}


}
