package com.liveperson.api.request.message;

import org.json.JSONObject;

/**
 * Created by Maayan on 03/02/2017.
 */
public class FormPublishMessage extends BasePublishMessage {
	public static final String FORM_ID = "formId";
	public static final String INVITATION_ID = "invitationId";
	public static final String TITLE = "title";

	private String mTitle;
    private String mInvitationId;
    private String mFormId;

	private JSONObject mJSONObject;
	/**
	 * Build a PublishMessage from a JSONObject
	 * @param jsonObject
	 */
	public FormPublishMessage(JSONObject jsonObject) {
		if (jsonObject != null) {
			mFormId = jsonObject.optString(FORM_ID);
			mInvitationId = jsonObject.optString(INVITATION_ID);
			mTitle = jsonObject.optString(TITLE);
			mJSONObject = jsonObject;
		}
	}

	@Override
    public JSONObject getMessage() {
        return mJSONObject;
    }

	@Override
	public PublishMessageType getType() {
		return PublishMessageType.FORM_INVITATION;
	}

	public String getInvitationId() {return mInvitationId;}

	public String getFormId() {return mFormId;}

	public String getFormTitle() {
		return mTitle;
	}

	@Override //TODO maayan
	public String getMessageText() {
		return getMessageTextWithoutSpecialChars(mJSONObject.toString());
	}
}
