package com.liveperson.messaging.commands.tasks

import android.os.Bundle
import com.liveperson.infra.log.LPLog
import com.liveperson.infra.network.socket.SocketManager
import com.liveperson.infra.utils.LocalBroadcast
import com.liveperson.messaging.Messaging
import com.liveperson.messaging.network.socket.requests.SubscribeMessagingEventsRequest

/**
 * Created by shiranr on 1/30/18.
 */

class MessagingEventSubscriptionManager {

    companion object {
        @JvmStatic
        val SUCCESS = "TASK_SUCCESS"
        @JvmStatic
        val ERROR_MESSAGE = "TASK_ERROR_MESSAGE"
        @JvmStatic
        val MESSAGE_EVENT_COMPLETED = "MESSAGE_EVENT_COMPLETED"

        fun onError(conversationId: String) {
            val bundle = Bundle()
            bundle.putBoolean(SUCCESS, false)
            LocalBroadcast.sendBroadcast(MESSAGE_EVENT_COMPLETED + conversationId, bundle)
        }
    }

    private var subscribedDialogs : HashMap<String, Boolean> = HashMap()
    private var subscribedDialogUIUpdate : HashMap<String, Boolean> = HashMap()

    fun addSubscription(controller : Messaging, brandID : String, conversationId : String, dialogId: String, fromSeq: Int = 0, updateUI: Boolean) {
        @Suppress("NAME_SHADOWING") // after we sanitize the input we don't want the unsafe version anyway.
        var fromSeq = fromSeq
        if (fromSeq == -1) {
            fromSeq = 0
        }

        val url: String = controller.mAccountsController.getConnectionUrl(brandID).guard { LPLog.w("SubscriptionManager", "The brand (wih ID: $brandID) has no connection URL!"); return }

        if (!subscribedDialogs.contains(dialogId)) {
            LPLog.w("SubscriptionManager", "Adding subscription for dialogId: $dialogId from seq: $fromSeq")
            subscribedDialogs[dialogId] = true
            subscribedDialogUIUpdate[dialogId] = updateUI

            val subscribe = SubscribeMessagingEventsRequest(url, conversationId, dialogId, fromSeq)
            SocketManager.getInstance().send(subscribe)
        } else {
            LPLog.w("SubscriptionManager", "Already added subscription for dialogId: $dialogId Subscription already exists!")
            //send intent its completed - only if we got notification already
            /*if (firstNotificationAfterSubscribe[conversationId] == false){
                LPMobileLog.w("SubscriptionManager", " $conversationId Subscription already exists! and already got event.")
                onReceivedEvent(conversationId)
            }*/
        }
    }

    fun onReceivedEvent(dialogId: String): Boolean {
        //send intent its completed
        var oldValue = subscribedDialogs[dialogId]

        if (oldValue == null){
            //in case firstNotificationAfterSubscribe was cleared
            oldValue = false
        }

        if (oldValue == true) {
            LPLog.w("SubscriptionManager", "onReceivedEvent! sending intent notification received for dialogId: $dialogId")
            val bundle = Bundle()
            bundle.putBoolean(SUCCESS, true)
            LocalBroadcast.sendBroadcast(MESSAGE_EVENT_COMPLETED + dialogId, bundle)
            subscribedDialogs[dialogId] = false
        }
        return oldValue
    }

    fun shouldUpdateUI(conversationId: String): Boolean {
        var oldValue = subscribedDialogUIUpdate[conversationId]
        subscribedDialogUIUpdate[conversationId] = true

        if (oldValue == null){
            oldValue = false
        }

        return oldValue
    }

    fun clearAllSubscriptions() {
        subscribedDialogs.clear()
    }

}

// Extension for adding Swift's guard keyword, from: https://android.jlelse.eu/a-few-ways-to-implement-a-swift-like-guard-in-kotlin-ffd94027864e
inline fun <T> T.guard(block: T.() -> Unit): T {
    if (this == null) block(); this.let { return it }
}
