/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.BadgeCounterRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetUnreadMessagesCountCommand
implements Command {
    private static final String TAG = "GetUnreadMessagesCountCommand";
    private static final String PUSHER_BADGE_URL = "https://%s/api/account/%s/device/unread-messages-count?appId=%s&lpId=%s&v=2.0";
    private static final String BADGE_COUNT = "badge_count";
    private static final String BADGE_TIMESTAMP = "badge_timestamp";
    private static final String ERROR_UNABLE_TO_MAKE_REQUEST = "Unable to make request.";
    private static final String ERROR_SERVER_ERROR = "Server error: ";
    private static final long BADGE_LAST_TIMESTAMP_THRESHOLD = 10000L;
    private final Messaging mController;
    private String mBrandId;
    private ICallback<Integer, Exception> mCallback;
    private String mAppId;
    private LPAuthenticationParams authenticationParams;
    private static Map<String, Integer> unreadCountMapping;
    private PusherHelper pusherHelper;

    public GetUnreadMessagesCountCommand(Messaging messagingController, String brandId, String appId, LPAuthenticationParams authenticationParams, ICallback<Integer, Exception> callback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.mCallback = callback;
        this.authenticationParams = authenticationParams;
    }

    public void execute() {
        this.pusherHelper = new PusherHelper(this.mBrandId, this.mController);
        if (!this.isBadgeThresholdWasPassed(this.mBrandId)) {
            LPLog.INSTANCE.d(TAG, "Time threshold was not passed yet. Return cached data");
            this.returnCachedDetails();
        } else {
            LPLog.INSTANCE.d(TAG, "Time threshold was passed");
            if (this.authenticationParams == null || this.authenticationParams.getAuthType() != LPAuthenticationType.AUTH) {
                if (TextUtils.isEmpty((CharSequence)this.mAppId)) {
                    this.notifyError(new Exception("Unable to make request. Error: Missing appID"));
                    return;
                }
                this.sendRequest();
            } else {
                this.validateNetworkState();
            }
        }
    }

    private void notifySuccess(int counter) {
        if (this.mCallback != null) {
            Infra.instance.postOnMainThread(() -> this.mCallback.onSuccess((Object)counter));
        }
    }

    private void notifyError(Exception exception) {
        if (this.mCallback != null) {
            Infra.instance.postOnMainThread(() -> {
                if (exception instanceof SSLPeerUnverifiedException) {
                    this.mController.mEventsProxy.onError(TaskType.INVALID_CERTIFICATE, exception.getMessage());
                }
                this.mCallback.onError((Throwable)exception);
            });
        }
    }

    private void validateNetworkState() {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.authorizeAndSendRequest();
        } else {
            new SynchronizedInternetConnectionCallback(this::authorizeAndSendRequest).execute();
        }
    }

    private void authorizeAndSendRequest() {
        boolean isExecuting2 = new SynchronizedAuthenticationCompletedCallback(this.mController.mAccountsController, this.mBrandId, new ICallback<Void, Exception>(){

            public void onSuccess(Void value) {
                try {
                    GetUnreadMessagesCountCommand.this.sendRequest();
                }
                catch (Exception error) {
                    LPLog.INSTANCE.e(GetUnreadMessagesCountCommand.TAG, ErrorCode.ERR_000000D9, "sendRequest: Failed to obtain domain/consumerId/token to make request ", (Throwable)error);
                }
            }

            public void onError(Exception exception) {
                LPLog.INSTANCE.e(GetUnreadMessagesCountCommand.TAG, ErrorCode.ERR_000000DA, "authorizeAndSendRequest: Failed to authorize ", (Throwable)exception);
                GetUnreadMessagesCountCommand.this.notifyError(exception);
            }
        }).executeWithReturnValue();
        if (!isExecuting2 && this.authenticationParams != null) {
            this.mController.connect(this.mBrandId, this.authenticationParams, null, true);
        }
    }

    private String buildPusherURL(String pusherDomain, String consumerId) {
        return String.format(PUSHER_BADGE_URL, pusherDomain, this.mBrandId, this.mAppId, consumerId);
    }

    private void sendRequest() {
        if (this.pusherHelper == null) {
            this.pusherHelper = new PusherHelper(this.mBrandId, this.mController);
        }
        List<String> certificates = this.pusherHelper.getCertificatePinningKeys();
        String consumerId = this.pusherHelper.getConsumerId();
        if (TextUtils.isEmpty((CharSequence)consumerId)) {
            LPLog.INSTANCE.w(TAG, "sendRequest: Failed to get consumerId. Quit get badge counter");
            this.notifyError(new Exception("Unable to make request. Error: Missing consumerId"));
            return;
        }
        String pusherDomain = this.pusherHelper.getPusherDomain();
        if (TextUtils.isEmpty((CharSequence)pusherDomain)) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000014C, "sendRequest: pusherDomain does not exists. Failed to get badge counter");
            this.notifyError(new Exception("Unable to make request. Error: Missing domain"));
            return;
        }
        String pusherURL = this.buildPusherURL(pusherDomain, consumerId);
        String token = this.pusherHelper.getAuthToken();
        if (token == null) {
            this.notifyError(new Exception("Unable to make request. Error: Authorization failed. Token is missing or is invalid"));
            return;
        }
        new BadgeCounterRequest(pusherURL, token, certificates, (ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String json) {
                if (!TextUtils.isEmpty((CharSequence)json)) {
                    try {
                        JSONArray jsonArray = new JSONArray(json);
                        int count = 0;
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            JSONObject obj = jsonArray.getJSONObject(i);
                            int idCount = obj.optInt("badge");
                            String conversationId = obj.optString("conversationId");
                            if (unreadCountMapping == null) {
                                unreadCountMapping = new HashMap();
                            }
                            unreadCountMapping.put(conversationId, idCount);
                            count += idCount;
                        }
                        GetUnreadMessagesCountCommand.this.updateTimeStamp();
                        PreferenceManager.getInstance().setIntValue(GetUnreadMessagesCountCommand.BADGE_COUNT, GetUnreadMessagesCountCommand.this.mBrandId, count);
                        GetUnreadMessagesCountCommand.this.notifySuccess(count);
                    }
                    catch (Exception e) {
                        GetUnreadMessagesCountCommand.this.notifyError(e);
                    }
                } else {
                    LPLog.INSTANCE.e(GetUnreadMessagesCountCommand.TAG, ErrorCode.ERR_000000DB, "Returned an empty response from pusher");
                }
            }

            public void onError(Exception exception) {
                if (exception != null) {
                    try {
                        String mess = GetUnreadMessagesCountCommand.this.parseException(exception.getMessage());
                        JSONObject error = new JSONObject(mess);
                        String errorString = error.getString("error");
                        if (!TextUtils.isEmpty((CharSequence)errorString)) {
                            JSONObject errorBody = new JSONObject(errorString);
                            String statusCode = errorBody.getString("statusCode");
                            String internalCode = errorBody.getString("internalCode");
                            if (!statusCode.equals("404") && !internalCode.equals("23")) {
                                LPLog.INSTANCE.e(GetUnreadMessagesCountCommand.TAG, ErrorCode.ERR_000000DC, "Failed to send get unread message count to pusher. (http status: " + statusCode + ", internal: " + internalCode + ")", (Throwable)exception);
                                GetUnreadMessagesCountCommand.this.notifyError(new Exception(GetUnreadMessagesCountCommand.ERROR_SERVER_ERROR + exception.getMessage()));
                            } else {
                                GetUnreadMessagesCountCommand.this.notifySuccess(0);
                            }
                            GetUnreadMessagesCountCommand.this.updateTimeStamp();
                        }
                    }
                    catch (Exception e) {
                        LPLog.INSTANCE.e(GetUnreadMessagesCountCommand.TAG, ErrorCode.ERR_000000DD, "Failed to parse unread message count exception from pusher.", (Throwable)e);
                        GetUnreadMessagesCountCommand.this.notifyError(e);
                    }
                }
            }
        }).execute();
    }

    private String parseException(String exception) {
        return exception.substring(exception.indexOf(123));
    }

    private void updateTimeStamp() {
        PreferenceManager.getInstance().setLongValue(BADGE_TIMESTAMP, this.mBrandId, System.currentTimeMillis());
    }

    private void returnCachedDetails() {
        LPLog.INSTANCE.d(TAG, "Return cached badge counter");
        int count = PreferenceManager.getInstance().getIntValue(BADGE_COUNT, this.mBrandId, 0);
        this.notifySuccess(count);
    }

    private boolean isBadgeThresholdWasPassed(String brandId) {
        long lastTimestamp = PreferenceManager.getInstance().getLongValue(BADGE_TIMESTAMP, brandId, 0L);
        long delta = System.currentTimeMillis() - lastTimestamp;
        return lastTimestamp == 0L || delta > 10000L;
    }

    public void fetchUnreadCountMapping() {
        if (unreadCountMapping == null) {
            unreadCountMapping = new HashMap<String, Integer>();
            this.sendRequest();
        } else {
            Integer sum = 0;
            for (String key : unreadCountMapping.keySet()) {
                sum = sum + unreadCountMapping.get(key);
            }
            this.notifySuccess(sum);
        }
    }

    public static Map<String, Integer> getUnreadCountMapped() {
        return unreadCountMapping;
    }

    public static void clearMappedUnreadCount() {
        LPLog.INSTANCE.d(TAG, "Removing all mapped unread count data");
        unreadCountMapping = null;
    }
}

