/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.callbacks.AuthCallBack;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.model.errors.AuthError;
import com.liveperson.infra.model.types.FailureReason;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsUsers;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IdpTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "IdpTask";
    private final AmsUsers mAmsUsers;
    private AccountsController mAccountsController;
    private String mHostVersion;

    public IdpTask(AccountsController accountsController, AmsUsers amsUsers, String hostVersion) {
        this.mHostVersion = hostVersion;
        this.mAccountsController = accountsController;
        this.mAmsUsers = amsUsers;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running IDP task...");
        AmsConnectionAnalytics.idpTaskStart();
        LPAuthenticationParams auth = this.mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (Infra.instance.getConsumerManager().getActiveConsumer() != null && auth.getAuthType() == LPAuthenticationType.SIGN_UP) {
            Infra.instance.getConsumerManager().setIsAuthenticated();
            this.onTaskComplete();
            return;
        }
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        String connectorId = this.mAccountsController.getAccount(this.mBrandId).getConnectorId();
        Infra.instance.getConsumerManager().login(auth, this.getIdpDomain(), this.mHostVersion, certificates, connectorId, new AuthCallBack(){

            public void onAuthSuccess(@NonNull Consumer consumer) {
                LPLog.INSTANCE.d(IdpTask.TAG, "onAuthSuccess: Consumer: " + LPLog.INSTANCE.mask((Object)consumer));
                IdpTask.this.mAmsUsers.updateConsumerId(IdpTask.this.mBrandId, consumer.getConsumerId());
                IdpTask.this.onTaskComplete();
            }

            public void onConsumerSwitch(@NotNull Consumer oldConsumer, @NotNull Consumer newConsumer) {
                IdpTask.this.switchUser(oldConsumer, newConsumer);
                IdpTask.this.mAmsUsers.updateConsumerId(IdpTask.this.mBrandId, newConsumer.getConsumerId());
                IdpTask.this.onTaskComplete();
            }

            public void onAuthFailed(@NotNull AuthError error) {
                if (error != null) {
                    LPLog.INSTANCE.d(IdpTask.TAG, "onAuthFailed: error: " + error.toString());
                    IdpTask.this.mCallback.onTaskError(TaskType.IDP, (FailureReason)error.getFailureReason(), error.getException());
                }
            }
        });
    }

    private String getIdpDomain() {
        String idpDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "idp");
        if (TextUtils.isEmpty((CharSequence)idpDomain)) {
            idpDomain = PreferenceManager.getInstance().getStringValue("idp", this.mBrandId, null);
        }
        if (TextUtils.isEmpty((CharSequence)idpDomain)) {
            String asyncMessagingEnt = this.mAccountsController.getServiceUrl(this.mBrandId, "asyncMessagingEnt");
            idpDomain = asyncMessagingEnt.replaceFirst("msg", "idp");
        }
        return idpDomain;
    }

    private void switchUser(Consumer oldConsumer, Consumer newConsumer) {
        String consumerId = newConsumer.getConsumerId();
        String oldConsumerId = oldConsumer.getConsumerId();
        MessagingFactory.getInstance().getController().liteLogout(this.mBrandId, oldConsumerId, consumerId);
    }

    private void onTaskComplete() {
        this.mAccountsController.getAccount(this.mBrandId).sendAuthenticationCompletedStatus();
        AmsConnectionAnalytics.idpTaskEnd();
        this.mCallback.onTaskSuccess();
    }

    @Override
    public String getName() {
        return TAG;
    }
}

