package com.liveperson.messaging.commands;

import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;

/**
 * Created by shiranr on 14/01/2016.
 */
public class QueryMessagesUMSCommand extends BasicQueryMessagesCommand {

    private static final String TAG = "QueryMessagesUMSCommand";
    private int lastCurrentSequence;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;

    public QueryMessagesUMSCommand(Messaging controller, String brandId, String conversationId, String dialogId, int lastCurrentSequence, boolean updateUI) {
        super(controller, brandId, conversationId, dialogId, updateUI);

        this.lastCurrentSequence = lastCurrentSequence;
    }

    @Override
    public void execute() {

        LPLog.INSTANCE.d(TAG,"Sending query messages from sequence " + lastCurrentSequence );
        controller.getMessagingEventSubscriptionManager().addSubscription(controller, brandID, conversationId, dialogId, lastCurrentSequence, mUpdateUI);
    }

    @Override
    public void setResponseCallBack(BaseAmsSocketConnectionCallback callBack) {
        super.setResponseCallBack(callBack);
        if (mLocalBroadcastReceiver == null) {
            mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder()
                    .addAction(MessagingEventSubscriptionManager.Companion.getMESSAGE_EVENT_COMPLETED() + dialogId)
                    .build((context, intent) -> {
                        mLocalBroadcastReceiver.unregister();
	                    LPLog.INSTANCE.d(TAG,"Got Message Event notification for dialog id: " + dialogId + " conversation ID: " + conversationId + ". Sending callback finished successfully");
                        if (intent.getBooleanExtra(MessagingEventSubscriptionManager.Companion.getSUCCESS(),false)){
                            mResponseCallBack.onTaskSuccess();
                        }else{
                            mResponseCallBack.onTaskError(SocketTaskType.QUERY_MESSAGES, new Exception(intent.getStringExtra(MessagingEventSubscriptionManager.Companion.getERROR_MESSAGE())));
                        }
                    });
        }
        mLocalBroadcastReceiver.register();
    }


}
