/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements.complex;

import com.liveperson.messaging.structuredcontent.model.elements.BaseElement;
import com.liveperson.messaging.structuredcontent.model.elements.complex.ComplexElement;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class LayoutElement
extends ComplexElement {
    private boolean mVerticalOrientation;

    public LayoutElement(String type, boolean verticalOrientation) {
        super(type);
        this.mVerticalOrientation = verticalOrientation;
    }

    public LayoutElement(JSONObject layout) throws JSONException {
        super(layout);
        this.mVerticalOrientation = this.mType.equals("vertical");
    }

    public boolean isVerticalOrientation() {
        return this.mVerticalOrientation;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + "{\n");
        sb.append("Elements[\n");
        if (this.mElementList != null) {
            for (BaseElement baseElement : this.mElementList) {
                sb.append(baseElement.toString());
            }
        }
        sb.append("]\n");
        sb.append("}\n");
        return sb.toString();
    }
}

