package com.liveperson.messaging.commands.tasks;

import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.AmsConnectionAnalytics;

/**
 * Created by nirni on 12/15/16.
 * A task to remove older images from storage
 */

public class RemoveOlderImagesTask extends BaseAmsAccountConnectionTask {

	private static final String TAG = "RemoveOlderImagesTask";

	private String brandId;

	public RemoveOlderImagesTask(String brandId) {
		this.brandId = brandId;
	}

	@Override
	public void execute() {

		AmsConnectionAnalytics.removeOlderImagesTaskStart();
		MessagingFactory.getInstance().getController().removeMultipleOlderImages(brandId);

		AmsConnectionAnalytics.removeOlderImagesTaskEnd();
		mCallback.onTaskSuccess();
	}

	@Override
	public String getName() {
		return TAG;
	}
}
