package com.liveperson.messaging.structuredcontent.model.elements;

import com.liveperson.messaging.structuredcontent.parsers.ElementType;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * This is the abstract base element for all elements that are not actions (basic and complex)
 * It includes the tooltip and rtl that are properties of all elements
 */
public abstract class SimpleElement extends BaseElement {

	private String mTooltip;

	public SimpleElement(String type) {
		super(type);
	}

	public SimpleElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);

		mTooltip = jsonObject.optString(ElementType.TOOLTIP);
	}

	public String getTooltip() {
		return mTooltip;
	}
}
