/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements.complex;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liveperson.messaging.structuredcontent.model.elements.BaseElement;
import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementParser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ComplexElement
extends SimpleElement {
    protected List<BaseElement> mElementList;
    private String mElementsKeyName = "elements";

    public ComplexElement(String type) {
        super(type);
        this.mElementList = new ArrayList<BaseElement>();
    }

    public ComplexElement(JSONObject jsonObject, @Nullable String elementsKeyName) throws JSONException {
        super(jsonObject);
        if (!TextUtils.isEmpty((CharSequence)elementsKeyName)) {
            this.mElementsKeyName = elementsKeyName;
        }
        this.mElementList = new ArrayList<BaseElement>();
        JSONArray elements = jsonObject.getJSONArray(this.mElementsKeyName);
        for (int i = 0; i < elements.length(); ++i) {
            JSONObject elementJSONObject = elements.getJSONObject(i);
            SimpleElement elementToAdd = ElementParser.parse(elementJSONObject);
            if (elementToAdd == null) continue;
            this.mElementList.add(elementToAdd);
        }
    }

    public ComplexElement(JSONObject jsonObject) throws JSONException {
        this(jsonObject, null);
    }

    public void addElement(SimpleElement element) {
        this.mElementList.add(element);
    }

    public List<BaseElement> getElementList() {
        return this.mElementList;
    }
}

