package com.liveperson.messaging.background.filesharing;

import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.network.http.RestRequestParams;

public class UploadFileTaskBundle extends BaseTaskBundle {

	protected Uri mFileUri;
	protected String mFilePath;
	private int taskId;
	protected String mFileContentType;
	protected String mFileTypeExtension;
	private MaskedMessage maskedMessage;

	public UploadFileTaskBundle build(int taskId, Context context) {
		setTaskID(taskId);

		mFilePath = mFileUri.getPath();

		String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl(mFileUri.toString());
		if (fileExtensionFromUrl != null) {
			mFileTypeExtension = fileExtensionFromUrl.toUpperCase();
		}

		if (mFileTypeExtension != null) {
			mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(mFileTypeExtension.toLowerCase());
		}

		return this;
	}

	public UploadFileTaskBundle addBrandId(String brandId) {
		super.addBrandId(brandId);
		return this;
	}

	public UploadFileTaskBundle addTargetId(String targetId) {
		super.addTargetId(targetId);
		return this;
	}

	public UploadFileTaskBundle addSwiftDomain(String swiftDomain) {
		super.addSwiftDomain(swiftDomain);
		return this;

	}

	public UploadFileTaskBundle addRestDomain(RestRequestParams restRequestParams) {
		super.addRestDomain(restRequestParams);
		return this;
	}

	public UploadFileTaskBundle addFileUri(Uri fileUri) {
		this.mFileUri = fileUri;
		return this;
	}

	public UploadFileTaskBundle addMessage(MaskedMessage maskedMessage) {
		this.maskedMessage = maskedMessage;
		return this;
	}

	public String getFilePath() {
		return mFilePath;
	}

	protected void setTaskID(int taskId) {
		this.taskId = taskId;
	}

	public int getTaskId() {
		return taskId;
	}

	public MaskedMessage getMessage() {
		return maskedMessage;
	}

	public String getFileContentType() {
		return mFileContentType;
	}

	public String getFileTypeExtension() {
		return mFileTypeExtension;
	}

	public String getSwiftDomain() {
		return mSwiftDomain;
	}

	public RestRequestParams getRestParams() {
		return mRestRequestParams;
	}

	public Uri getFileUri() {
		return mFileUri;
	}
}
