package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.infra.utils.Utils;
import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Text element. Holds a string
 */
public class MapElement extends ActionableElement {

	private float mLatitude;
	private float mLongitude ;

	public MapElement() {
		super(ElementType.MAP);
	}

	/**
	 * This sets text body from the given json.

	 * @param jsonObject
	 * @throws JSONException
	 */
	public MapElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);

		String latitude = jsonObject.getString(ElementType.LA); // Mandatory
		String longitude = jsonObject.getString(ElementType.LO); // Mandatory
		mLatitude = Utils.tryParse(latitude, (float) 0);
		mLongitude = Utils.tryParse(longitude, (float) 0);
	}


	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + " - " + mLatitude + " : " + mLongitude + " \n");

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	public float getLongitude() {
		return mLongitude;
	}

	public float getLatitude() {
		return mLatitude;
	}
}
