/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.types;

import android.text.TextUtils;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;

public enum CloseReason {
    CONSUMER,
    AGENT,
    SYSTEM,
    TIMEOUT;

    private static final String TAG = "CloseReason";

    public static CloseReason parse(int ordinal) {
        CloseReason result = SYSTEM;
        CloseReason[] values = CloseReason.values();
        if (ordinal < values.length) {
            result = values[ordinal];
        }
        return result;
    }

    public static CloseReason parse(String closeReasonString) {
        CloseReason result = SYSTEM;
        if (TextUtils.isEmpty((CharSequence)closeReasonString)) {
            return result;
        }
        try {
            result = CloseReason.valueOf(closeReasonString);
        }
        catch (Exception e) {
            CloseReason[] values;
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000057, "Failed to parse CloseReason from string: " + closeReasonString, (Throwable)e);
            for (CloseReason closeReason : values = CloseReason.values()) {
                if (!closeReason.name().equalsIgnoreCase(closeReasonString)) continue;
                result = closeReason;
                break;
            }
        }
        return result;
    }
}

