/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.model.Participants;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.model.CoBrowseMetadata;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.Dialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class DialogData
extends MultiDialog {
    private static final String TAG = "DialogData";
    public DialogState state;
    public String assignedAgentId;
    public String dialogId;
    public String conversationId;
    @Deprecated
    private String[] participants;
    public Participants participantsDetails;
    public DialogType dialogType;
    public String closedCause;
    public CoBrowseMetadata metaData;
    public long creationTs;
    public long metaDataLastUpdateTs;
    public long endTs;
    public boolean isOpen;
    public CloseReason closeReason;

    public DialogData(JSONObject jsonObject) {
        super(jsonObject);
        JSONArray participantsArray = jsonObject.optJSONArray("participants");
        if (participantsArray == null) {
            participantsArray = new JSONArray();
        }
        this.participants = new String[participantsArray.length()];
        for (int i = 0; i < participantsArray.length(); ++i) {
            String participantId = participantsArray.optString(i);
            if (TextUtils.isEmpty((CharSequence)participantId)) continue;
            this.participants[i] = participantId;
        }
        this.parseParticipantsDetails(jsonObject);
        JSONObject cobrowseMetadata = jsonObject.optJSONObject("metaData");
        if (cobrowseMetadata != null) {
            this.metaData = new CoBrowseMetadata(cobrowseMetadata);
        }
        this.dialogId = jsonObject.optString("dialogId");
        this.closeReason = CloseReason.parse(jsonObject.optString("closedBy"));
        this.creationTs = jsonObject.optLong("creationTs", -1L);
        this.metaDataLastUpdateTs = jsonObject.optLong("metaDataLastUpdateTs", -1L);
        this.endTs = jsonObject.optLong("endTs", -1L);
        this.closedCause = jsonObject.optString("closedCause");
        this.dialogType = DialogType.parse(jsonObject.optString("dialogType"));
        this.channelType = MultiDialog.ChannelType.parse(jsonObject.optString("channelType"));
        this.state = DialogState.parse(jsonObject.optString("state"));
        this.isOpen = this.state == DialogState.OPEN;
    }

    protected DialogData(JSONObject jsonObject, @Nullable String conversationId) {
        this(jsonObject);
        if (TextUtils.isEmpty((CharSequence)conversationId) && TextUtils.isEmpty((CharSequence)(conversationId = jsonObject.optString("convId")))) {
            conversationId = this.dialogId;
        }
        this.conversationId = conversationId;
        if (TextUtils.isEmpty((CharSequence)this.dialogId)) {
            this.dialogId = this.conversationId;
        }
    }

    @Deprecated
    protected DialogData(ConversationData conversationData) {
        this(new JSONObject(), conversationData.conversationId);
        this.participants = conversationData.participants.extractAllParticipantsIds();
        this.participantsDetails = conversationData.participants;
        this.dialogType = DialogType.MAIN;
        this.channelType = MultiDialog.ChannelType.MESSAGING;
        this.closeReason = conversationData.closeReason;
        this.setState(DialogState.parse(conversationData.state));
        this.assignedAgentId = conversationData.getAssignedAgentId();
    }

    public DialogData(Dialog dialog) {
        this.assignedAgentId = dialog.getAssignedAgentId();
        this.participantsDetails = dialog.getParticipants();
        this.participants = this.participantsDetails.extractAllParticipantsIds();
        this.channelType = dialog.getChannelType();
        this.dialogType = dialog.getDialogType();
        this.conversationId = dialog.getConversationId();
        this.dialogId = dialog.getDialogId();
        this.closeReason = dialog.getCloseReason();
        this.endTs = dialog.getEndTimestamp();
        this.creationTs = dialog.getStartTimestamp();
        this.state = dialog.getState();
        this.isOpen = this.state == DialogState.OPEN;
    }

    private void parseParticipantsDetails(JSONObject jsonObject) {
        JSONArray participantsDetailsJson = jsonObject.optJSONArray("participantsDetails");
        if (participantsDetailsJson != null && participantsDetailsJson.length() > 0) {
            this.participantsDetails = new Participants();
            HashMap participantsDetailsMap = new HashMap();
            for (int i = 0; i < participantsDetailsJson.length(); ++i) {
                Participants.ParticipantRole role;
                JSONObject participantDetailsJson = participantsDetailsJson.optJSONObject(i);
                if (participantDetailsJson == null) continue;
                String participantId = participantDetailsJson.optString("id");
                String participantRole = participantDetailsJson.optString("role").toUpperCase();
                if (TextUtils.isEmpty((CharSequence)participantId) || (role = Participants.ParticipantRole.parse(participantRole)) == null) continue;
                ArrayList ids = (ArrayList)participantsDetailsMap.get((Object)role);
                if (ids == null) {
                    ids = new ArrayList();
                    participantsDetailsMap.put(role, ids);
                }
                ((ArrayList)participantsDetailsMap.get((Object)role)).add(participantId);
            }
            Set roles = participantsDetailsMap.keySet();
            for (Participants.ParticipantRole role : roles) {
                this.participantsDetails.add((ArrayList)participantsDetailsMap.get((Object)role), role);
            }
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000005D, "The 'participantsDetails' is empty / missing, is the server's version too old?");
        }
    }

    public static DialogData[] extractDialogsData(ConversationData conversationData) {
        DialogData[] dialogsData;
        if (conversationData.dialogs == null || conversationData.dialogs.length == 0) {
            if (conversationData.dialogs == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000005E, "Missing dialogs array! Creating a new one from the conversation's data.");
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000005F, "Dialogs array is empty! Creating a new one from the conversation's data.");
            }
            dialogsData = new DialogData[]{new DialogData(conversationData)};
        } else {
            dialogsData = conversationData.dialogs;
        }
        return dialogsData;
    }

    public static String extractDialogId(ConversationData conversationData) {
        String dialogId = conversationData.dialogs != null && conversationData.dialogs.length > 0 && conversationData.dialogs[0] != null ? conversationData.dialogs[0].dialogId : conversationData.conversationId;
        return dialogId;
    }

    public String toString() {
        return "{ dialogId: " + this.dialogId + ", creationTs: " + this.creationTs + ", endTs: " + this.endTs + " }";
    }

    public void setState(DialogState dialogState) {
        this.state = dialogState;
        this.isOpen = this.state == DialogState.OPEN;
    }
}

