/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.media.ExifInterface;
import com.liveperson.infra.Infra;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.image.UploadImageTaskBundle;
import com.liveperson.messaging.commands.SendImageCommand;
import com.liveperson.messaging.exception.FileSharingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class UploadImageTask
extends BaseUploadTask {
    private static final String TAG = "UploadImageTask";
    protected String mBase64 = null;
    protected UploadImageTaskBundle uploadImageTaskParams;
    private byte[] mOriginalFileByteArray = null;

    public UploadImageTask(UploadImageTaskBundle params, Integer uploadTimeout) throws FileSharingException {
        super(uploadTimeout);
        int orientation = 0;
        if (params == null) {
            throw new FileSharingException("Params is null");
        }
        this.uploadImageTaskParams = params;
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "imageTypeExtension = " + this.uploadImageTaskParams.getFileTypeExtension() + ", imageContentType = " + this.uploadImageTaskParams.getFileContentType());
        try {
            try {
                ExifInterface exif = new ExifInterface(this.uploadImageTaskParams.getFilePath());
                orientation = exif.getAttributeInt("Orientation", 1);
            }
            catch (FileNotFoundException e) {
                LPLog.INSTANCE.w(TAG, "UploadImageTask: cannot get orientation from exif. Using default (0)", (Throwable)e);
            }
            Bitmap thumbnailBitmap = this.processThumbnailImage(orientation, this.uploadImageTaskParams.isImageFromCamera());
            Bitmap originalBitmap = this.processOriginalImage(orientation, this.uploadImageTaskParams.isImageFromCamera());
            String thumbnailPath = this.saveThumbnailImage(thumbnailBitmap);
            String fullImagePath = this.saveOriginalImage(originalBitmap);
            LPLog.INSTANCE.d(TAG, "UploadImageTask: Image and thumbnail created. Continue to send image to server");
            this.createSendMessageCommand(thumbnailPath, fullImagePath);
        }
        catch (IOException e) {
            LPLog.INSTANCE.e(TAG + Thread.currentThread(), ErrorCode.ERR_000000B0, "error resizing or saving image", (Throwable)e);
            this.onUploadFailed(e);
            throw new FileSharingException("error resizing or saving image");
        }
    }

    @Override
    protected UploadFileTaskBundle getUploadTaskBundle() {
        return this.uploadImageTaskParams;
    }

    @Override
    protected byte[] getFileByteArray() {
        return this.mOriginalFileByteArray;
    }

    @Override
    public int getTaskId() {
        return this.uploadImageTaskParams.getTaskId();
    }

    @Override
    public String getThumbnailBase64() {
        return this.mBase64;
    }

    @NonNull
    protected Bitmap processOriginalImage(int orientation, boolean fromCamera) throws IOException {
        int fullImageLongerDimensionResize = Configuration.getInteger((int)R.integer.full_image_longer_dimension_resize);
        Bitmap originalBitmap = ImageUtils.createResizedBitmap((Uri)this.uploadImageTaskParams.getFileUri(), (int)fullImageLongerDimensionResize, (int)orientation, (boolean)fromCamera);
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "originalBitmap size (w, h): " + originalBitmap.getWidth() + ", " + originalBitmap.getHeight());
        return originalBitmap;
    }

    @NonNull
    protected String saveOriginalImage(Bitmap originalBitmap) throws FileSharingException {
        String fullImagePath = this.convertAndSaveFullImage(originalBitmap, this.uploadImageTaskParams.getFilePath(), this.uploadImageTaskParams.isImageFromCamera(), this.uploadImageTaskParams.getFileTypeExtension());
        if (fullImagePath == null) {
            LPLog.INSTANCE.d(TAG, "UploadImageTask: file is too large after compression");
            throw new FileSharingException("File is too large after compression");
        }
        return fullImagePath;
    }

    @NonNull
    protected Bitmap processThumbnailImage(int orientation, boolean fromCamera) throws IOException {
        int thumbnailLongerDimensionResize = Configuration.getInteger((int)R.integer.thumbnail_longer_dimension_resize);
        Bitmap thumbnailBitmap = ImageUtils.createResizedBitmap((Uri)this.uploadImageTaskParams.getFileUri(), (int)thumbnailLongerDimensionResize, (int)orientation, (boolean)fromCamera);
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "thumbnailBitmap size: " + thumbnailBitmap.getWidth() + ", " + thumbnailBitmap.getHeight());
        return thumbnailBitmap;
    }

    @NonNull
    protected String saveThumbnailImage(Bitmap thumbnailBitmap) throws FileSharingException {
        String thumbnailPath = this.saveThumbnail(thumbnailBitmap, this.uploadImageTaskParams.getFileTypeExtension());
        if (thumbnailPath == null) {
            LPLog.INSTANCE.e(TAG + Thread.currentThread(), ErrorCode.ERR_000000B1, "run: Could not save image thumbnail to disk");
            throw new FileSharingException("Could not save thumbnailBitmap image to disk");
        }
        return thumbnailPath;
    }

    private String saveThumbnail(Bitmap mThumbnail, String imageTypeExtension) {
        byte[] thumbnailByteArray;
        if (!imageTypeExtension.equals("jpg") && !imageTypeExtension.equals("png")) {
            imageTypeExtension = "jpg";
        }
        if ((thumbnailByteArray = ImageUtils.getOutputStreamFromBitmap((Bitmap)mThumbnail, (int)100, (String)imageTypeExtension)) == null) {
            return null;
        }
        this.mBase64 = ImageUtils.bitmapToBase64((byte[])thumbnailByteArray);
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "run: Thumbnail Base64: " + this.mBase64);
        return ImageUtils.saveBitmapToDisk((Context)Infra.instance.getApplicationContext(), (byte[])thumbnailByteArray, (String)this.uploadImageTaskParams.getBrandId(), (ImageUtils.ImageFolderType)ImageUtils.ImageFolderType.PREVIEW, (String)imageTypeExtension);
    }

    private String convertAndSaveFullImage(Bitmap mOriginalBitmap, String originalImagePath, boolean saveOnOriginalPath, String imageTypeExtension) {
        this.createOriginalImageByteArray(mOriginalBitmap, imageTypeExtension);
        if (this.mOriginalFileByteArray == null) {
            return null;
        }
        LPLog.INSTANCE.d(TAG, "convertAndSaveFullImage: size of full image file (after compression): " + this.mOriginalFileByteArray.length);
        int maxImageSizeKb = Configuration.getInteger((int)R.integer.max_image_size_kb);
        if (this.mOriginalFileByteArray.length > maxImageSizeKb * 1000) {
            return null;
        }
        if (saveOnOriginalPath) {
            return ImageUtils.saveBitmapToDisk((byte[])this.mOriginalFileByteArray, (File)new File(originalImagePath));
        }
        return ImageUtils.saveBitmapToDisk((Context)Infra.instance.getApplicationContext(), (byte[])this.mOriginalFileByteArray, (String)this.uploadImageTaskParams.getBrandId(), (ImageUtils.ImageFolderType)ImageUtils.ImageFolderType.FULL, (String)imageTypeExtension);
    }

    protected void createOriginalImageByteArray(Bitmap mOriginalBitmap, String imageTypeExtension) {
        int compressionRate = Configuration.getInteger((int)R.integer.full_image_compression_rate);
        LPLog.INSTANCE.d(TAG, "convertAndSaveFullImage: compression rate for full image: " + compressionRate);
        this.mOriginalFileByteArray = ImageUtils.getOutputStreamFromBitmap((Bitmap)mOriginalBitmap, (int)compressionRate, (String)imageTypeExtension);
    }

    protected void createSendMessageCommand(String thumbnailPath, String fullImagePath) {
        this.sendMessageCommand = new SendImageCommand(MessagingFactory.getInstance().getController(), this.uploadImageTaskParams.getTargetId(), this.uploadImageTaskParams.getBrandId(), this.uploadImageTaskParams.getFileContentType(), thumbnailPath, fullImagePath, this.uploadImageTaskParams.getFileTypeExtension(), this.uploadImageTaskParams.getMessage());
        this.setSendMessageCommandCallback();
    }
}

