/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import com.liveperson.api.request.GetUserProfile;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.network.socket.requests.GetUserProfileRequest;

public class GetConsumerUserTask
extends BaseAmsSocketConnectionTask {
    private static final String TAG = "GetConsumerUserTask";
    private final Messaging mController;

    public GetConsumerUserTask(Messaging controller) {
        this.mController = controller;
    }

    public void execute() {
        String consumerId = this.mController.amsUsers.getConsumerId(this.mBrandId);
        if (!TextUtils.isEmpty((CharSequence)consumerId)) {
            this.mCallback.onTaskSuccess();
        } else {
            GetUserProfileRequest userProfileRequest = new GetUserProfileRequest(this.mController, this.mBrandId, UserProfile.UserType.CONSUMER);
            userProfileRequest.addCallback((ResponseCallback)new ResponseCallback<GetUserProfile.Response>(){
                private LocalBroadcastReceiver receiver;

                public void onSuccess(GetUserProfile.Response data) {
                    this.receiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_CONSUMER_ID_ACTION").build((context, intent) -> {
                        if (GetConsumerUserTask.this.mBrandId.equals(intent.getStringExtra("BRAND_ID_EXTRA"))) {
                            this.receiver.unregister();
                            GetConsumerUserTask.this.mCallback.onTaskSuccess();
                        }
                    });
                }

                public void onError() {
                    GetConsumerUserTask.this.mCallback.onTaskError(SocketTaskType.GET_USER, new Exception(GetConsumerUserTask.TAG));
                }
            });
            SocketManager.getInstance().send((BaseSocketRequest)userProfileRequest);
        }
    }
}

