package com.liveperson.api.request;


import com.liveperson.api.response.AbstractResponse;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Maayan on 8/3/2017.
 */
public class GeneratedUploadTokenField extends BaseGenerateURL {

	public static final String READ_OTK = "readOtk";
	public static final String WRITE_OTK = "writeOtk";

	private static final String TAG = "GenUploadTokenField";

	public static final String GENERATE_UPLOAD_TOKEN_TYPE = "ms.GenerateUploadToken";
	private static final String JSON_KEY_BODY_UPLOADABLE = "uploadable";
	private static final String JSON_KEY_BODY_TYPE = "type";
	private static final String JSON_VALUE_BODY_TYPE = "SecureForm";
	private static final String JSON_KEY_BODY_DIALOG_ID = "dialogId";
	private static final String JSON_KEY_BODY_FORM_ID = "formId";
	private static final String JSON_KEY_BODY_INVITATION_ID = "invitationId";

	private String json_key_body_dialog_id_value;
	private String json_key_body_form_id_value;
	private String json_key_body_invitation_id_value;

	public GeneratedUploadTokenField(String dialogId , String formId, String invitationId) {
		json_key_body_dialog_id_value = dialogId;
		json_key_body_form_id_value = formId;
		json_key_body_invitation_id_value = invitationId;
	}


	@Override
    public String getMessageType() {
        return GENERATE_UPLOAD_TOKEN_TYPE;
    }

	/**
	 * json example :
	 * {
	 "id":43,
	 "type":".ams.ms.token.GenerateUploadToken",
	 "kind":"req",
	 "body":{
		 "uploadable":{
		 "type":"SecureForm",
		 "dialogId":"0326a768-0aec-4b2f-b51e-3ee13d145c42",
		 "formId":"546812112",
		 "invitationId":"maayan5"
	 	}
	 }}
	 * @param json
	 * @throws JSONException
	 */
	@Override
	protected void toJson(JSONObject json) throws JSONException {
		JSONObject convContext = new JSONObject();
		convContext.put(JSON_KEY_TYPE, GENERATE_UPLOAD_TOKEN_TYPE);

		convContext.put(JSON_KEY_BODY_TYPE, JSON_VALUE_BODY_TYPE);
		convContext.put(JSON_KEY_BODY_DIALOG_ID, json_key_body_dialog_id_value);
		convContext.put(JSON_KEY_BODY_FORM_ID, json_key_body_form_id_value);
		convContext.put(JSON_KEY_BODY_INVITATION_ID, json_key_body_invitation_id_value);

		body.put(JSON_KEY_BODY_UPLOADABLE, convContext);

		json.put(AbstractRequest.JSON_KEY_BODY, body);
	}


	/**
	 * {
	 "kind":"resp",
	 "reqId":"43",
	 "code":200,
		 "body":{
			 "token":{
			 "type":"SecureFormReadWriteToken",
			 "readOtk":"1b7970b8-71f2-4041-bb17-3c94a1e85b10",
			 "writeOtk":"969a4c50-0e39-466d-b252-5c7bbccb8787"
			 }
	 	},
	 "type":".ams.ms.token.GenerateUploadToken$Response"
	 }
	 */
	public static class Response extends AbstractResponse<Response.Body> {
        public static String GENERATE_UPLOAD_RESPONSE_TYPE = "ms.UploadToken";

        public Body body = new Body();

        public Response(JSONObject obj) throws JSONException {
            super(obj);

            JSONObject inner = obj.getJSONObject(JSON_KEY_BODY);
            JSONObject innerBody = inner.getJSONObject("token");
            body.type = innerBody.getString(JSON_KEY_BODY_TYPE);
            body.readOtk = innerBody.getString(READ_OTK);
            body.writeOtk = innerBody.getString(WRITE_OTK);
        }

        @Override
        public Response.Body getBody() {
            return body;
        }

		public static class Body {
			public String type;
			public String readOtk;
			public String writeOtk;
		}

    }
}
