package com.liveperson.api.response;

import org.json.JSONException;
import org.json.JSONObject;


/**
 * Created by oferd on 8/9/15.
 */
public abstract class AbstractResponse<T> {
    public static final String GENERAL_INNER_RESPONSE = "$Response";

    public int reqId;
    public int code;

    public AbstractResponse(JSONObject obj) {
        if (obj == null){
            return;
        }
        //general response
        String kind = obj.optString("kind", "resp");
        String type = obj.optString("type", "AbstractResponse");

        //response to request
        reqId = obj.optInt("reqId", -1);
        code = obj.optInt("code", 200);
    }

    public abstract T getBody();
}
