package com.liveperson.messaging.background.filesharing;

import android.content.Context;

import com.liveperson.messaging.network.http.RestRequestParams;


/**
 * Created by shiranr on 7/24/16.
 */
public class DownloadFileTaskBundle extends BaseTaskBundle{

    private static final String TAG = "DownloadFileTaskBundle";
    private String mRelativePath;
    private long mFileRowId;
    private long mMessageRowId;
    private String mConversationId;
    private Context mContext;

    public DownloadFileTaskBundle addBrandId(String brandId) {
		super.addBrandId(brandId);
        return this;
    }

    public DownloadFileTaskBundle addTargetId(String targetId) {
		super.addTargetId(targetId);
        return this;
    }

	public DownloadFileTaskBundle addRestDomain(RestRequestParams restRequestParams) {
		super.addRestDomain(restRequestParams);
		return this;
	}

	public DownloadFileTaskBundle addSwiftDomain(String swiftDomain) {
		super.addSwiftDomain(swiftDomain);
		return this;
	}

	public DownloadFileTaskBundle addRelativePath(String relativePath) {
        this.mRelativePath = relativePath;
        return this;
    }

    public DownloadFileTaskBundle addMessageRowId(long messageRowId) {
        this.mMessageRowId = messageRowId;
        return this;
    }

    public DownloadFileTaskBundle addFileRowId(long fileRowId) {
        this.mFileRowId = fileRowId;
        return this;
    }

    public DownloadFileTaskBundle addConversationId(String conversationId) {
        this.mConversationId = conversationId;
        return this;
    }

    public DownloadFileTaskBundle build(long taskId, Context context) {
        long taskId1 = taskId;
        mContext = context;
        return this;
    }

    public String getBrandId() {
        return mBrandId;
    }
    public String getRelativePath() {
        return mRelativePath;
    }

    public String getTargetId() {
        return mTargetId;
    }

    public String getSwiftDomain() {
        return mSwiftDomain;
    }
    public RestRequestParams getRestParams() {
        return mRestRequestParams;
    }

    public long getFileRowId() {
        return mFileRowId;
    }

    public Context getContext() {
        return mContext;
    }

    public long getMessageRowId() {
        return mMessageRowId;
    }

    public String getConversationId(){
        return mConversationId;
    }
}
