package com.liveperson.messaging.commands;

import androidx.annotation.NonNull;

import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.socket.requests.SendFormSubmissionMessageRequest;


/**
 * Created by Maayan on 9/3/2017
 * A command for sending message about the form submitted (for pci)
 */
public class SendFormSubmissionMessageCommand extends SendMessageCommand {

    private static final String TAG = SendFormSubmissionMessageCommand.class.getSimpleName();
    private String mSubmittionId;
    private String mInvitationId;

	/**
	 * Creates a command for sending messages
	 *
	 * @param controller
	 * @param message
	 */
	public SendFormSubmissionMessageCommand(Form form, MaskedMessage message, Messaging controller){
		super(controller, form.getSiteId(), form.getSiteId(), message);
		mBrandId = form.getSiteId();
		mTargetId = form.getSiteId();
		mMessage = message;
		mSubmittionId = form.getSubmissionId();
		mInvitationId = form.getInvitationId();
	}

    @NonNull
    protected MessagingChatMessage createNewChatMessage(String conversationId, MaskedMessage message) {
        return new MessagingChatMessage(mConsumerId,
                message.getDbMessage(),
				System.currentTimeMillis(),
                conversationId,
                mEventId,
                MessagingChatMessage.MessageType.CONSUMER_FORM,
                MessagingChatMessage.MessageState.PENDING,
                EncryptionVersion.NONE);
    }

	@NonNull
	@Override
	protected SendFormSubmissionMessageRequest createMessageRequest(Messaging mController, String mEventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
		SendFormSubmissionMessageRequest sendMessageRequest = new SendFormSubmissionMessageRequest(mController, mEventId, mTargetId,
				mBrandId, dialogId, conversationId, mMessage.getServerMessage(), mInvitationId, mSubmittionId);
		return sendMessageRequest;
	}

}