/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request;

import androidx.annotation.Nullable;
import com.liveperson.api.request.AbstractRequest;
import com.liveperson.api.request.message.PublishMessage;
import com.liveperson.api.response.AbstractResponse;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.model.types.ChatState;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublishEvent
extends AbstractRequest {
    public static final String CHAT_TYPE = "chatState";
    public static final String MESSAGE = "message";
    public static final String DIALOG_ID = "dialogId";
    public static final String CONVERSATION_ID = "conversationId";
    public static final String TYPE = "type";
    public static final String EVENT = "event";
    public static final String SUBSCRIPTION_ID = "subscriptionId";
    public static final String STATUS = "status";
    public static final String SEQUENCE_LIST = "sequenceList";
    public static final String SEQUENCE = "sequence";
    private static final String CONTENT_TYPE = "contentType";
    private static final String EVENT_ID = "eventId";
    private static final String INFO = "info";
    private static final String CONTENT_ID = "contentId";
    private static final String ACTION_ID = "actionId";
    public static final String PUBLISH_EVENT_TYPE = "ms.PublishEvent";
    public static final String METADATA = "metadata";
    private String dialogId;
    private String conversationId;
    private PublishMessage message;
    private ChatState chatState;
    private String status;
    int[] sequenceList;
    private Type type;
    private ContentType contentType;
    private String eventId;
    private DeliveryStatusUpdateInfo info;

    public PublishEvent(String dialogId, String conversationId, PublishMessage msg, Type type, ContentType contentEvent, String eventId, @Nullable DeliveryStatusUpdateInfo info) {
        this.dialogId = dialogId;
        this.conversationId = conversationId;
        this.message = msg;
        this.contentType = contentEvent;
        this.type = type;
        this.eventId = eventId;
        this.info = info;
    }

    public PublishEvent(String dialogId, String conversationId, Type type, ChatState chatState) {
        this.dialogId = dialogId;
        this.conversationId = conversationId;
        this.type = type;
        this.chatState = chatState;
    }

    public PublishEvent(String dialogId, String conversationId, Type type, String status, int[] sequenceList, @Nullable DeliveryStatusUpdateInfo info) {
        this.dialogId = dialogId;
        this.conversationId = conversationId;
        this.type = type;
        this.status = status;
        this.sequenceList = sequenceList;
        this.info = info;
    }

    @Override
    public String getMessageType() {
        return PUBLISH_EVENT_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        JSONObject body = new JSONObject();
        body.put(DIALOG_ID, (Object)this.dialogId);
        body.put(CONVERSATION_ID, (Object)this.conversationId);
        JSONObject eventJson = new JSONObject();
        eventJson.put(TYPE, (Object)this.type.name());
        switch (this.type) {
            case ContentEvent: {
                eventJson.put(CONTENT_TYPE, (Object)this.contentType.getText());
                eventJson.put(MESSAGE, this.message.getMessage());
                body.put(EVENT_ID, (Object)this.eventId);
                if (this.info == null) break;
                json.put(METADATA, (Object)this.info.getMetadata());
                break;
            }
            case ChatStateEvent: {
                eventJson.put(CHAT_TYPE, (Object)this.chatState.name());
                break;
            }
            case AcceptStatusEvent: {
                eventJson.put(STATUS, (Object)this.status);
                JSONArray list = new JSONArray();
                for (int i = 0; i < this.sequenceList.length; ++i) {
                    list.put(this.sequenceList[i]);
                }
                eventJson.put(SEQUENCE_LIST, (Object)list);
                if (this.info == null) break;
                json.put(METADATA, (Object)this.info.getMetadata());
            }
        }
        body.put(EVENT, (Object)eventJson);
        json.put("body", (Object)body);
    }

    public static class Response
    extends AbstractResponse<Body> {
        public static final String PUBLISH_EVENT_RESPONSE_TYPE = "ms.PublishEventResponse";
        Body body = new Body();

        public Response(JSONObject obj) throws JSONException {
            super(obj);
            JSONObject innerBody = obj.getJSONObject("body");
            if (innerBody != null) {
                this.body.sequence = innerBody.optInt(PublishEvent.SEQUENCE, -1);
            }
        }

        @Override
        public Body getBody() {
            return this.body;
        }

        public static class Body {
            public int sequence;
        }
    }

    public static enum Type {
        ContentEvent,
        ChatStateEvent,
        AcceptStatusEvent;

    }
}

