/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.voice;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.Utils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.commands.SendVoiceCommand;
import com.liveperson.messaging.exception.FileSharingException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class UploadVoiceTask
extends BaseUploadTask {
    public static final String TAG = "UploadVoiceTask";
    protected UploadFileTaskBundle uploadFileTaskBundle;
    private String previewBase64;
    protected String previewContentType;

    public UploadVoiceTask(UploadFileTaskBundle params, Integer uploadTimeout) throws FileSharingException {
        super(uploadTimeout);
        if (params == null) {
            throw new FileSharingException("Params is null");
        }
        this.uploadFileTaskBundle = params;
        File file = new File(this.uploadFileTaskBundle.getFilePath());
        if (file == null) {
            throw new FileSharingException("File path is null");
        }
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        try {
            BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
            buf.read(bytes, 0, bytes.length);
            buf.close();
            this.mOriginalFileByteArray = bytes;
        }
        catch (IOException e) {
            LPMobileLog.e((String)TAG, (String)"UploadVoiceTask: cannot extract file byteArray. Aborting upload file");
            return;
        }
        this.generatePreviewImage();
        this.createSendMessageCommand(this.createThumbnail(), params.getFilePath());
    }

    protected void createSendMessageCommand(String thumbnailPath, String filePath) {
        this.sendMessageCommand = new SendVoiceCommand(MessagingFactory.getInstance().getController(), this.uploadFileTaskBundle.getTargetId(), this.uploadFileTaskBundle.getBrandId(), this.uploadFileTaskBundle.getFileContentType(), thumbnailPath, filePath, this.uploadFileTaskBundle.getFileTypeExtension(), this.uploadFileTaskBundle.getMessage(), this.previewContentType);
        this.setSendMessageCommandCallback();
    }

    private void generatePreviewImage() {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)Utils.getResources(), (int)R.drawable.lp_messaging_dummy_file_thumbnal);
        this.previewBase64 = ImageUtils.bitmapToBase64((Bitmap)bitmap);
        this.previewContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension("png");
    }

    private String createThumbnail() {
        return null;
    }

    @Override
    protected UploadFileTaskBundle getUploadTaskBundle() {
        return this.uploadFileTaskBundle;
    }

    @Override
    protected byte[] getFileByteArray() {
        return this.mOriginalFileByteArray;
    }

    @Override
    public int getTaskId() {
        return this.uploadFileTaskBundle.getTaskId();
    }

    @Override
    public String getThumbnailBase64() {
        return this.previewBase64;
    }
}

