/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.Command;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.network.socket.requests.ChangeConversationTTRRequest;

public class ChangeConversationTTRCommand
implements Command {
    private static final String TAG = ChangeConversationTTRCommand.class.getSimpleName();
    private final AmsConversations mAmsConversations;
    private TTRType mTTRType;
    private String mSocketUrl;
    private String mTargetId;

    public ChangeConversationTTRCommand(AmsConversations amsConversations, String targetId, String socketUrl, TTRType ttrType) {
        this.mAmsConversations = amsConversations;
        this.mTargetId = targetId;
        this.mSocketUrl = socketUrl;
        this.mTTRType = ttrType;
    }

    public void execute() {
        if (!this.mAmsConversations.isConversationActive(this.mTargetId)) {
            LPMobileLog.w((String)TAG, (String)"No open conversation found. aborting changing ttr type command");
            return;
        }
        String conversationServerId = this.mAmsConversations.getConversation(this.mTargetId).getConversationId();
        ChangeConversationTTRRequest baseSocketRequest = new ChangeConversationTTRRequest(this.mSocketUrl, conversationServerId, this.mTTRType, 0);
        SocketManager.getInstance().send((BaseSocketRequest)baseSocketRequest);
    }
}

