/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.SparseIntArray;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.BasicQueryMessagesCommand;
import com.liveperson.messaging.commands.QueryMessagesUMSCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;
import com.liveperson.messaging.commands.tasks.UpdateEmptyDialogCommand;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.DialogUtils;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.network.http.QueryMessagesINCACommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class FetchConversationManager {
    private static final String TAG = FetchConversationManager.class.getSimpleName();
    protected final Messaging mController;
    protected ConversationUtils mConversationUtils;
    protected DialogUtils mDialogUtils;
    protected HashSet usersUpdating = new HashSet();
    protected int numConversationToUpdateUI;
    private final HashMap<String, LocalBroadcastReceiver> didDialogGetMessages = new HashMap();

    public FetchConversationManager(Messaging controller) {
        this.mController = controller;
        this.init();
    }

    protected void init() {
        this.mConversationUtils = new ConversationUtils(this.mController);
        this.mDialogUtils = new DialogUtils(this.mController);
    }

    public void fetchConversationsFirstTime(final String brandId, List<ConversationData> dataFromUMS, List<ConversationData> dataFromInca) {
        int incaSize;
        if (this.isCollectionEmpty(dataFromUMS) && this.isCollectionEmpty(dataFromInca)) {
            this.mController.mConnectionController.getConnection(brandId).setIsUpdated(true);
            this.mController.amsMessages.updateFetchHistoryEnded(brandId);
            return;
        }
        int numConversationToFetch = Configuration.getInteger((int)R.integer.idp_num_history_conversation);
        if (numConversationToFetch < 0) {
            numConversationToFetch = 2;
        }
        int umsSize = this.isCollectionEmpty(dataFromUMS) ? 0 : dataFromUMS.size();
        int n = incaSize = this.isCollectionEmpty(dataFromInca) ? 0 : dataFromInca.size();
        if (umsSize + incaSize < numConversationToFetch) {
            numConversationToFetch = umsSize + incaSize;
        }
        this.numConversationToUpdateUI = numConversationToFetch;
        if (numConversationToFetch > 0) {
            boolean shouldFetchMessages;
            ArrayBlockingQueue<QueryRequestMessage> queue = new ArrayBlockingQueue<QueryRequestMessage>(numConversationToFetch * 2);
            this.waitFetchConversationFinished(brandId, null, numConversationToFetch, queue, true);
            int i = 0;
            if (dataFromUMS != null) {
                for (ConversationData conversationData : dataFromUMS) {
                    shouldFetchMessages = i < numConversationToFetch;
                    LPMobileLog.d((String)TAG, (String)("Saving conversation #" + i + " source: UMS. bringing messages: " + shouldFetchMessages));
                    this.fetchConversation(conversationData, shouldFetchMessages, queue, i, DATA_SOURCE.UMS);
                    ++i;
                }
            }
            if (dataFromInca != null) {
                for (ConversationData conv : dataFromInca) {
                    shouldFetchMessages = i < numConversationToFetch;
                    LPMobileLog.d((String)TAG, (String)("Saving conversation #" + i + " source: INCA. bringing messages: " + shouldFetchMessages));
                    this.fetchConversation(conv, shouldFetchMessages, queue, i, DATA_SOURCE.INCA);
                    ++i;
                }
            }
            LPMobileLog.d((String)TAG, (String)"Finished updating conversations in DB. waiting for query messages responses (if there is))");
        } else {
            int i = 0;
            for (ConversationData conversationData : dataFromUMS) {
                this.fetchConversation(conversationData, false, null, i, DATA_SOURCE.UMS);
                ++i;
            }
            for (ConversationData conversationData : dataFromInca) {
                this.fetchConversation(conversationData, false, null, i, DATA_SOURCE.INCA);
                ++i;
            }
            this.mController.amsMessages.updateOnCommand(brandId, null).setPreQueryOnBackground(new Runnable(){

                @Override
                public void run() {
                    LPMobileLog.d((String)TAG, (String)"Finished updating conversations in DB. waiting for query messages responses (if there is))");
                    FetchConversationManager.this.mController.mConnectionController.getConnection(brandId).setIsUpdated(true);
                }
            }).execute();
        }
    }

    private boolean isCollectionEmpty(List<ConversationData> collection) {
        return collection == null || collection.size() == 0;
    }

    public void fetchConversation(Conversation conversation, ArrayList<Dialog> dialogs) {
        if (!this.mController.mConnectionController.isSocketReady(conversation.getBrandId())) {
            LPMobileLog.i((String)TAG, (String)("Brand is not connected. can't fetch dialog for " + conversation.getConversationId()));
            this.mController.amsMessages.updateFetchHistoryEnded(conversation.getBrandId(), false);
            return;
        }
        this.fetchConversation(conversation, dialogs, false, true);
    }

    public void refreshConversation(Conversation conversation) {
        ArrayList<Dialog> dialogs = this.mController.amsDialogs.getDialogsByConversationId(conversation.getConversationId());
        if (dialogs.size() == 0) {
            LPMobileLog.e((String)TAG, (String)("Missing dialogs for conversation ID:" + conversation.getConversationId()));
            throw new RuntimeException("Missing dialogs for conversation ID:" + conversation.getConversationId());
        }
        this.fetchConversation(conversation, dialogs, true, false);
    }

    private void fetchConversation(Conversation conversation, ArrayList<Dialog> dialogs, boolean forceUpdateAgent, boolean addResolveMessage) {
        ArrayBlockingQueue<QueryRequestMessage> queue = new ArrayBlockingQueue<QueryRequestMessage>(dialogs.size());
        this.waitFetchConversationFinished(conversation.getBrandId(), conversation.getTargetId(), 1, queue, addResolveMessage);
        for (Dialog dialog : dialogs) {
            if (dialog != null) {
                String assignedAgentId = dialog.getAssignedAgentId();
                this.numConversationToUpdateUI = 1;
                ConversationData conversationData = new ConversationData(conversation.getBrandId(), conversation, dialogs);
                DATA_SOURCE source = conversation.isConversationOpen() || DateUtils.isInTheLast24hours((long)conversation.getEndTimestamp()) ? DATA_SOURCE.UMS : DATA_SOURCE.INCA;
                LPMobileLog.i((String)TAG, (String)("Fetching dialog for " + conversation.getConversationId() + " sending request to query unread messages via " + source.name()));
                this.queryMessages(conversationData, dialog, queue, 0, source);
                this.mConversationUtils.updateParticipants(conversation.getTargetId(), conversation.getBrandId(), new String[]{assignedAgentId}, UserProfile.UserType.AGENT, dialog.getConversationId(), false, forceUpdateAgent);
                continue;
            }
            LPMobileLog.e((String)TAG, (String)("fetchConversation: Missing open dialog in conversation: " + conversation.getConversationId()));
        }
    }

    private void waitFetchConversationFinished(final String brandId, final String targetId, final int maxConversationHistory, final BlockingQueue<QueryRequestMessage> queue, final boolean addResolveMessage) {
        new Thread(new Runnable(){
            public LocalBroadcastReceiver mConnectionReceiver;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ArrayList<2> resolveMessagesListeners = new ArrayList<2>();
                boolean isTimedOut = false;
                QueryRequestMessage prevQueryRequestMessage = null;
                try {
                    if (!InternetConnectionService.isNetworkAvailable()) {
                        LPMobileLog.d((String)TAG, (String)"Can't fetch history from server. no network. ");
                        throw new IllegalStateException("Can't fetch history from server.  no network.");
                    }
                    this.registerNoConnectionEvents();
                    final SparseIntArray conversationsQueryMap = new SparseIntArray(maxConversationHistory);
                    boolean done = false;
                    while (!done) {
                        QueryRequestMessage queryRequestMessage = (QueryRequestMessage)queue.poll(15L, TimeUnit.SECONDS);
                        if (queryRequestMessage != null) {
                            if (queryRequestMessage.conversationData != null && queryRequestMessage.conversationData.dialogs != null) {
                                DialogData[] dialogs = queryRequestMessage.conversationData.dialogs;
                                for (int i = 0; i < dialogs.length; ++i) {
                                    final String dialogId = dialogs[i].dialogId;
                                    HashMap hashMap = FetchConversationManager.this.didDialogGetMessages;
                                    synchronized (hashMap) {
                                        if (FetchConversationManager.this.didDialogGetMessages.get(dialogId) == null) {
                                            LocalBroadcastReceiver broadcastReceiver = new LocalBroadcastReceiver.Builder().addAction(MessagingEventSubscriptionManager.Companion.getMESSAGE_EVENT_COMPLETED() + dialogId).build(new LocalBroadcastReceiver.IOnReceive(){

                                                public void onBroadcastReceived(Context context, Intent intent) {
                                                    LocalBroadcastReceiver receiver = (LocalBroadcastReceiver)FetchConversationManager.this.didDialogGetMessages.get(dialogId);
                                                    if (receiver != null) {
                                                        receiver.unregister();
                                                    }
                                                }
                                            });
                                            FetchConversationManager.this.didDialogGetMessages.put(dialogId, broadcastReceiver);
                                        }
                                        continue;
                                    }
                                }
                            }
                            LPMobileLog.d((String)TAG, (String)("waitFetchConversationFinished: didDialogGetMessages == " + FetchConversationManager.this.didDialogGetMessages.size()));
                            prevQueryRequestMessage = queryRequestMessage;
                        }
                        if (queryRequestMessage == null || queryRequestMessage.conversationIndex == -1) {
                            LPMobileLog.w((String)TAG, (String)"Fetching history thread was interrupted or timeout expired");
                            done = true;
                            isTimedOut = true;
                            continue;
                        }
                        int oldValue = conversationsQueryMap.get(queryRequestMessage.conversationIndex);
                        int newValue = oldValue + queryRequestMessage.value;
                        boolean success = queryRequestMessage.success;
                        conversationsQueryMap.put(queryRequestMessage.conversationIndex, newValue);
                        LPMobileLog.d((String)TAG, (String)("query maps requests " + conversationsQueryMap + " new value = " + newValue + " addResolveMessage = " + addResolveMessage + " success = " + success));
                        if (newValue != 0) continue;
                        ConversationData conversationData = queryRequestMessage.conversationData;
                        if (success && addResolveMessage && conversationData.state == ConversationState.CLOSE && conversationData.closeReason != CloseReason.TIMEOUT && conversationData.closeReason != CloseReason.SYSTEM) {
                            final QueryRequestMessage finalQueryRequestMessage = prevQueryRequestMessage;
                            ICallback<Void, Exception> listener = new ICallback<Void, Exception>(){

                                public void onSuccess(Void v) {
                                    this.checkIsDoneFetching();
                                }

                                public void onError(Exception e) {
                                    LPMobileLog.w((String)TAG, (String)("Failed adding resolve message: " + e.getMessage()));
                                    this.checkIsDoneFetching();
                                }

                                private void checkIsDoneFetching() {
                                    resolveMessagesListeners.remove(this);
                                    if (resolveMessagesListeners.isEmpty() && conversationsQueryMap.size() == 0) {
                                        this.finishFetching(finalQueryRequestMessage, false);
                                    }
                                }
                            };
                            resolveMessagesListeners.add(listener);
                            this.addResolveMessageToClosedConversation(queryRequestMessage, listener);
                        }
                        done = this.isDone(conversationsQueryMap);
                    }
                    conversationsQueryMap.clear();
                }
                catch (Exception e) {
                    LPMobileLog.w((String)TAG, (String)("Failed fetching messages from history: " + e.getMessage()));
                }
                finally {
                    FetchConversationManager.this.usersUpdating.clear();
                    if (this.mConnectionReceiver != null) {
                        this.mConnectionReceiver.unregister();
                    }
                    if (!resolveMessagesListeners.isEmpty()) {
                        LPMobileLog.d((String)TAG, (String)"Finished fetching messages from history but we are still waiting for Resolve messages to be added to DB...");
                    } else {
                        this.finishFetching(prevQueryRequestMessage, isTimedOut);
                    }
                }
            }

            protected boolean isDone(SparseIntArray conversationsQueryMap) {
                if (conversationsQueryMap.get(maxConversationHistory - 1, -1) == 0) {
                    for (int j = 0; j < maxConversationHistory; ++j) {
                        int value = conversationsQueryMap.get(j, -1);
                        if (value != 0) {
                            return false;
                        }
                        if (j != maxConversationHistory - 1) continue;
                        return true;
                    }
                }
                return false;
            }

            protected void finishFetching(QueryRequestMessage queryRequestMessage, boolean timedOut) {
                if (!FetchConversationManager.this.mController.mConnectionController.getConnection(brandId).isUpdated()) {
                    if (FetchConversationManager.this.mController.mConnectionController.isSocketReady(brandId)) {
                        FetchConversationManager.this.mController.mConnectionController.getConnection(brandId).setIsUpdated(true);
                    }
                    if (!TextUtils.isEmpty((CharSequence)targetId)) {
                        FetchConversationManager.this.updateFetchHistoryListener(targetId, queryRequestMessage, timedOut);
                    } else {
                        FetchConversationManager.this.updateFetchHistoryListener(brandId, queryRequestMessage, timedOut);
                    }
                } else {
                    FetchConversationManager.this.updateFetchHistoryListener(brandId, queryRequestMessage, timedOut);
                }
                LPMobileLog.d((String)TAG, (String)"Finished fetching messages from history ! ");
            }

            private void registerNoConnectionEvents() {
                this.mConnectionReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_KEY_SOCKET_READY_ACTION").build(new LocalBroadcastReceiver.IOnReceive(){

                    public void onBroadcastReceived(Context context, Intent intent) {
                        boolean isConnected;
                        String brandId = intent.getStringExtra("BROADCAST_KEY_BRAND_ID");
                        if (brandId.equals(brandId) && !(isConnected = intent.getBooleanExtra("BROADCAST_KEY_SOCKET_READY_EXTRA", false))) {
                            if (mConnectionReceiver != null) {
                                mConnectionReceiver.unregister();
                            }
                            queue.add(new QueryRequestMessage(-1, -1, null, false));
                        }
                    }
                });
            }

            private void addResolveMessageToClosedConversation(QueryRequestMessage queryRequestMessage, ICallback<Void, Exception> listener) {
                ConversationData conversationData = queryRequestMessage.conversationData;
                LPMobileLog.d((String)TAG, (String)("Adding resolve message to " + conversationData.conversationId + " index = " + queryRequestMessage.conversationIndex + " numConversationToUpdateUI = " + FetchConversationManager.this.numConversationToUpdateUI));
                ArrayList<Dialog> conversationDialogs = AmsDialogs.extractDialogs(conversationData);
                for (Dialog dialog : conversationDialogs) {
                    FetchConversationManager.this.mDialogUtils.addClosedDialogDivider(conversationData.targetId, dialog, conversationData.getAssignedAgentId(), dialog.getCloseReason(), queryRequestMessage.conversationIndex >= FetchConversationManager.this.numConversationToUpdateUI, listener);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFetchHistoryListener(final String brandOrTargetId, QueryRequestMessage queryRequestMessage, boolean timedOut) {
        if (timedOut) {
            HashMap<String, LocalBroadcastReceiver> hashMap = this.didDialogGetMessages;
            synchronized (hashMap) {
                for (String dialogId : this.didDialogGetMessages.keySet()) {
                    LocalBroadcastReceiver broadcastReceiver = this.didDialogGetMessages.get(dialogId);
                    if (broadcastReceiver == null) continue;
                    if (broadcastReceiver.isRegistered()) {
                        LPMobileLog.d((String)TAG, (String)("updateFetchHistoryListener: dialog ID has no messages: " + dialogId));
                        this.handleEmptyDialog(queryRequestMessage, dialogId, new BaseAmsSocketConnectionCallback(){

                            @Override
                            public void onTaskSuccess() {
                                FetchConversationManager.this.mController.amsMessages.updateFetchHistoryEnded(brandOrTargetId);
                            }

                            public void onTaskError(SocketTaskType type, Throwable exception) {
                                FetchConversationManager.this.mController.amsMessages.updateFetchHistoryEnded(brandOrTargetId);
                            }
                        });
                    }
                    broadcastReceiver.unregister();
                }
                this.didDialogGetMessages.clear();
            }
        } else {
            this.mController.amsMessages.updateFetchHistoryEnded(brandOrTargetId);
        }
    }

    private void handleEmptyDialog(QueryRequestMessage queryRequestMessage, String dialogId, BaseAmsSocketConnectionCallback callback) {
        if (queryRequestMessage != null && queryRequestMessage.conversationData != null) {
            LPMobileLog.e((String)TAG, (String)"MULTI_DIALOG_FLOW", (String)"QueryRequest timed out");
            UpdateEmptyDialogCommand command = new UpdateEmptyDialogCommand(this.mController, queryRequestMessage.conversationData.brandId, queryRequestMessage.conversationData.targetId, queryRequestMessage.conversationData.conversationId, dialogId, true);
            command.setResponseCallBack(callback);
            command.execute();
        }
    }

    private void fetchConversation(final ConversationData data, final boolean queryMessages, final BlockingQueue<QueryRequestMessage> queue, final int conversationIndex, final DATA_SOURCE source) {
        switch (data.state) {
            case CLOSE: {
                this.mController.amsConversations.updateClosedConversation(data, false).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Conversation>(){

                    public void onResult(Conversation updatedConversation) {
                        ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
                        for (Dialog dialog : dialogs) {
                            FetchConversationManager.this.mController.amsDialogs.updateClosedDialog(data, dialog, false).executeSynchronously();
                            if (!queryMessages) continue;
                            if (updatedConversation != null) {
                                LPMobileLog.d((String)TAG, (String)("Sending request to query unread messages... newer than sequence: " + updatedConversation.getLastServerSequence() + " source = " + (Object)((Object)source)));
                                FetchConversationManager.this.queryMessages(data, dialog, queue, conversationIndex, source);
                                continue;
                            }
                            FetchConversationManager.this.addRequestToQueue(queue, conversationIndex, data, 0);
                        }
                        FetchConversationManager.this.updateAllUsersRelatedToConversation(data, queryMessages, queue, conversationIndex);
                    }
                }).execute();
                break;
            }
            case OPEN: {
                Conversation conversation = this.mController.amsConversations.createNewCurrentConversation(data);
                ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
                Dialog dialog = AmsDialogs.getOpenDialog(dialogs);
                this.mController.amsDialogs.createNewCurrentDialog(dialog);
                this.mController.amsDialogs.setActiveDialog(dialog);
                long effectiveTTR = this.mConversationUtils.calculateEffectiveTTR(data.brandId, data.conversationTTRType, data.ttrValue, data.manualTTR, data.delayTillWhen);
                this.mConversationUtils.updateTTR(data.conversationTTRType, effectiveTTR, data.delayTillWhen, data.brandId);
                LPMobileLog.d((String)TAG, (String)("We have a new Current Dialog! " + dialog.getDialogId() + ". Sending request to query messages and update assigned agent details"));
                this.updateAllUsersRelatedToConversation(data, queryMessages, queue, conversationIndex);
                if (!queryMessages) break;
                this.queryMessages(data, dialog, queue, conversationIndex, source);
            }
        }
    }

    private void updateAllUsersRelatedToConversation(ConversationData data, boolean isBringingData, BlockingQueue<QueryRequestMessage> queue, int conversationIndex) {
        for (String user : data.participants.ALL_AGENTS) {
            this.getDataForUser(data, user, UserProfile.UserType.AGENT, isBringingData, queue, conversationIndex);
        }
        for (String user : data.participants.CONTROLLER) {
            this.getDataForUser(data, user, UserProfile.UserType.CONTROLLER, isBringingData, queue, conversationIndex);
        }
    }

    private void getDataForUser(final ConversationData data, String user, UserProfile.UserType userType, boolean isBringingData, final BlockingQueue<QueryRequestMessage> queue, final int conversationIndex) {
        if (!this.usersUpdating.contains(user)) {
            this.usersUpdating.add(user);
            ICallback<MessagingUserProfile, Exception> callback = null;
            if (isBringingData) {
                LPMobileLog.d((String)TAG, (String)("Bringing user data for conversation index: " + conversationIndex + " agent: " + user));
                this.addRequestToQueue(queue, conversationIndex, data, 1);
                callback = new ICallback<MessagingUserProfile, Exception>(){

                    public void onSuccess(MessagingUserProfile value) {
                        LPMobileLog.d((String)TAG, (String)("onSuccess Bringing user data for conversation index: " + conversationIndex));
                        FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, data, -1, true);
                    }

                    public void onError(Exception exception) {
                        LPMobileLog.d((String)TAG, (String)("onError Bringing user data for conversation index: " + conversationIndex));
                        FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, data, -1, true);
                    }
                };
            }
            this.mConversationUtils.updateParticipants(data.targetId, data.brandId, new String[]{user}, userType, null, false, true, callback);
        }
    }

    private void queryMessages(final ConversationData conversationData, Dialog dialog, final BlockingQueue<QueryRequestMessage> queue, final int conversationIndex, DATA_SOURCE source) {
        BasicQueryMessagesCommand command = null;
        switch (source) {
            case UMS: {
                command = new QueryMessagesUMSCommand(this.mController, conversationData.brandId, conversationData.targetId, conversationData.conversationId, dialog.getDialogId(), dialog.getLastServerSequence(), false);
                break;
            }
            case INCA: {
                command = new QueryMessagesINCACommand(this.mController, conversationData.brandId, conversationData.targetId, conversationData.conversationId, dialog.getDialogId(), false);
            }
        }
        command.setResponseCallBack(new BaseAmsSocketConnectionCallback(){

            @Override
            public void onTaskSuccess() {
                FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, conversationData, -1, true);
            }

            public void onTaskError(SocketTaskType type, Throwable exception) {
                FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, conversationData, -1, false);
            }
        });
        this.addRequestToQueue(queue, conversationIndex, conversationData, 1);
        command.execute();
    }

    private void addRequestToQueue(BlockingQueue<QueryRequestMessage> queue, int conversationIndex, ConversationData conversationData, int value) {
        try {
            LPMobileLog.d((String)TAG, (String)("#" + conversationIndex + " Adding " + value + " to queue"));
            queue.put(new QueryRequestMessage(conversationIndex, value, conversationData, true));
        }
        catch (InterruptedException e) {
            LPMobileLog.e((String)TAG, (String)("#" + conversationIndex + " Problem adding to query messages queue"));
        }
    }

    private void addResponseToQueue(BlockingQueue<QueryRequestMessage> queue, int conversationIndex, ConversationData conversationData, int value, boolean success) {
        try {
            LPMobileLog.d((String)TAG, (String)("#" + conversationIndex + " Adding " + value + " to queue"));
            queue.put(new QueryRequestMessage(conversationIndex, value, conversationData, success));
        }
        catch (InterruptedException e) {
            LPMobileLog.e((String)TAG, (String)("#" + conversationIndex + " Problem adding to query messages queue"));
        }
    }

    private class QueryRequestMessage {
        int conversationIndex;
        int value;
        boolean success;
        ConversationData conversationData;

        public QueryRequestMessage(int conversationIndex, int value, ConversationData conversationData, boolean success) {
            this.conversationIndex = conversationIndex;
            this.value = value;
            this.conversationData = conversationData;
            this.success = success;
        }
    }

    public static enum DATA_SOURCE {
        UMS,
        INCA;

    }
}

