/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller;

import android.content.Context;
import android.content.Intent;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownAsync;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.AmsConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConnectionsController
implements ShutDownAsync,
Clearable {
    private static final String TAG = ConnectionsController.class.getSimpleName();
    public static final String KEY_PREF_LAST_UPDATE_TIME = "KEY_PREF_LAST_UPDATE_TIME";
    protected Map<String, AmsConnection> mBrandConnection;
    protected Map<String, String> mSubscriptionBrand;
    protected Messaging mController;
    protected LocalBroadcastReceiver mConnectionReceiver = null;

    public ConnectionsController(Messaging messagingController) {
        this.mController = messagingController;
        this.mBrandConnection = new HashMap<String, AmsConnection>();
        this.mSubscriptionBrand = new HashMap<String, String>();
    }

    public void initConnectionReceiver() {
        if (this.mConnectionReceiver == null) {
            LPMobileLog.d((String)TAG, (String)"Registering Connection Receiver");
            this.mConnectionReceiver = new LocalBroadcastReceiver.Builder().addAction("CONNECTION_CONNECTED").addAction("CONNECTION_DISCONNECTED").build(new LocalBroadcastReceiver.IOnReceive(){

                public void onBroadcastReceived(Context context, Intent intent) {
                    String action;
                    LPMobileLog.d((String)TAG, (String)("-----Broadcast----- " + intent.getAction()));
                    switch (action = intent.getAction()) {
                        case "CONNECTION_CONNECTED": {
                            ConnectionsController.this.onResumeConnection();
                            break;
                        }
                        case "CONNECTION_DISCONNECTED": {
                            for (String brandId : ConnectionsController.this.mBrandConnection.keySet()) {
                                ConnectionsController.this.networkLost(brandId);
                            }
                            break;
                        }
                    }
                }
            });
        }
    }

    protected void onResumeConnection() {
        for (String brandId : this.mBrandConnection.keySet()) {
            this.networkAvailable(brandId);
        }
    }

    public void unregisterConnectionReceiver() {
        if (this.mConnectionReceiver != null) {
            LPMobileLog.d((String)TAG, (String)"Unregistering Connection Receiver");
            this.mConnectionReceiver.unregister();
            this.mConnectionReceiver = null;
        }
    }

    public void addNewConnection(String brand) {
        if (this.getConnection(brand) == null) {
            LPMobileLog.i((String)TAG, (String)("Adding new AmsConnection: " + brand));
            this.mBrandConnection.put(brand, new AmsConnection(this.mController, brand));
        } else {
            this.getConnection(brand).init();
        }
    }

    public boolean isSocketOpen(String brand) {
        AmsConnection connection = this.getConnection(brand);
        return connection != null && connection.isSocketOpen();
    }

    public boolean isSocketReady(String brand) {
        AmsConnection connection = this.getConnection(brand);
        return connection != null && connection.isSocketReady();
    }

    public boolean isConnecting(String brand) {
        AmsConnection connection = this.getConnection(brand);
        return connection != null && connection.isConnecting();
    }

    public boolean isUpdated(String brand) {
        AmsConnection connection = this.getConnection(brand);
        return connection != null && connection.isUpdated();
    }

    public AmsConnection.AmsSocketState registerSocket(String brand) {
        AmsConnection connection = this.getConnection(brand);
        if (connection == null) {
            return null;
        }
        return connection.registerSocket();
    }

    public void connect(String brand, boolean connectInBackground, boolean clearToken) {
        AmsConnection connection = this.getConnection(brand);
        if (connection == null) {
            return;
        }
        connection.startConnecting(connectInBackground, clearToken);
    }

    public void connect(String brand) {
        this.connect(brand, false, false);
    }

    public void disconnect(String brand) {
        AmsConnection connection = this.getConnection(brand);
        if (connection == null) {
            return;
        }
        connection.startDisconnecting();
    }

    public void networkLost(String brandId) {
        AmsConnection connection = this.getConnection(brandId);
        if (connection == null) {
            return;
        }
        connection.networkLost();
    }

    public void networkAvailable(String brandId) {
        AmsConnection connection = this.getConnection(brandId);
        if (connection == null) {
            return;
        }
        connection.networkAvailable();
    }

    public void moveToForeground(String brandId) {
        AmsConnection connection = this.getConnection(brandId);
        if (connection != null) {
            connection.moveToForeground();
        }
    }

    public void moveToBackground(String brandId, long timeout) {
        AmsConnection connection = this.getConnection(brandId);
        if (connection != null) {
            connection.moveToBackground(timeout);
        }
    }

    public void serviceStarted(String brandId) {
        AmsConnection connection = this.getConnection(brandId);
        if (connection != null) {
            connection.serviceStarted();
        }
    }

    public void serviceStopped(String brandId) {
        AmsConnection connection = this.getConnection(brandId);
        if (connection != null) {
            connection.serviceStopped();
        }
    }

    public long getClockDiff(String brand) {
        AmsConnection connection = this.getConnection(brand);
        if (connection == null) {
            return 0L;
        }
        return connection.getClockDiff();
    }

    public void setClockDiff(String brand, long clock) {
        AmsConnection connection = this.getConnection(brand);
        connection.setClock(clock);
    }

    public String getBrandIDForSubscription(String subscriptionID) {
        return this.mSubscriptionBrand.get(subscriptionID);
    }

    public void setLastUpdateTime(String subscriptionID, long updatedTime) {
        String brand = this.mSubscriptionBrand.get(subscriptionID);
        AmsConnection connection = this.getConnection(brand);
        if (connection == null) {
            return;
        }
        connection.setLastUpdateTime(updatedTime);
    }

    public void clearLastUpdateTime(String brandId) {
        AmsConnection connection = this.getConnection(brandId);
        if (connection == null) {
            return;
        }
        connection.setLastUpdateTime(0L);
    }

    public boolean isLastUpdateTimeExists(String subscriptionID) {
        String brand = this.mSubscriptionBrand.get(subscriptionID);
        AmsConnection connection = this.getConnection(brand);
        return connection != null && connection.isLastUpdateTimeExists();
    }

    public void setSubscription(String brandId, String subscriptionId) {
        Iterator<Map.Entry<String, String>> it = this.mSubscriptionBrand.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> subscription = it.next();
            if (!subscription.getValue().equals(brandId)) continue;
            it.remove();
        }
        this.mSubscriptionBrand.put(subscriptionId, brandId);
    }

    public String getSubscriptionId(String brandId) {
        for (Map.Entry<String, String> subscription : this.mSubscriptionBrand.entrySet()) {
            if (!subscription.getValue().equals(brandId)) continue;
            return subscription.getKey();
        }
        return null;
    }

    public long getLastUpdateTime(String brand) {
        AmsConnection connection = this.getConnection(brand);
        return connection == null ? 0L : connection.getLastUpdateTime();
    }

    public boolean isFirstNotificationAfterSubscribe(String brand) {
        AmsConnection connection = this.getConnection(brand);
        if (connection == null) {
            return false;
        }
        return connection.isFirstNotificationAfterSubscribe();
    }

    public void setFirstNotificationAfterSubscribe(String brand, boolean firstNotificationAfterSubscribe) {
        AmsConnection connection = this.getConnection(brand);
        if (connection == null) {
            return;
        }
        connection.setFirstNotificationAfterSubscribe(firstNotificationAfterSubscribe);
    }

    public AmsConnection getConnection(String brand) {
        return this.mBrandConnection.get(brand);
    }

    public void shutDown(ShutDownCompletionListener listener) {
        this.unregisterConnectionReceiver();
        Collection<AmsConnection> connections = this.mBrandConnection.values();
        int numOfConnections = connections.size();
        if (numOfConnections > 0) {
            AmsConnectionShutDownCompletionListener connectionCounterListener = new AmsConnectionShutDownCompletionListener(numOfConnections, listener);
            for (AmsConnection amsConnection : connections) {
                amsConnection.shutDown(connectionCounterListener);
            }
        } else {
            listener.shutDownCompleted();
        }
    }

    public void clear() {
        this.mSubscriptionBrand.clear();
        this.mBrandConnection.clear();
    }

    private static class AmsConnectionShutDownCompletionListener
    implements ShutDownCompletionListener {
        private ShutDownCompletionListener listener;
        int numOfConnections;

        public AmsConnectionShutDownCompletionListener(int numOfConnections, ShutDownCompletionListener listener) {
            this.listener = listener;
            this.numOfConnections = numOfConnections;
        }

        public void shutDownCompleted() {
            --this.numOfConnections;
            if (this.numOfConnections == 0) {
                this.listener.shutDownCompleted();
            }
        }

        public void shutDownFailed() {
        }
    }
}

