/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.ForegroundServiceInterface;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.state.SocketStateListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownAsync;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.StateMachineExecutor;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.infra.statemachine.interfaces.IStateMachineExecutor;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.IMessaging;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.InitAmsSessionCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionCallback;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.controller.connection.ConnectionStateMachine;
import com.liveperson.messaging.controller.connection.IConnectionListener;
import com.liveperson.messaging.controller.connection.InternetInformationProvider;
import com.liveperson.messaging.controller.connection.MessagingStateMachineInterface;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.AmsUsers;

public class AmsConnection
implements ShutDownAsync {
    protected static final String TAG = AmsConnection.class.getSimpleName();
    private static final int IDP_TOKEN_EXPIRED_UNAUTHENTICATED_FLOW = 4407;
    private static final int IDP_TOKEN_EXPIRED_AUTHENTICATED_FLOW = 4401;
    public static final String BROADCAST_CONNECTING_TO_SERVER_ERROR = "BROADCAST_CONNECTING_TO_SERVER_ERROR";
    public static final String BROADCAST_START_CONNECTING = "BROADCAST_START_CONNECTING";
    public static final String BROADCAST_SOCKET_OPEN_ACTION = "BROADCAST_SOCKET_OPEN_ACTION";
    public static final String BROADCAST_KEY_SOCKET_READY_ACTION = "BROADCAST_KEY_SOCKET_READY_ACTION";
    public static final String BROADCAST_KEY_SOCKET_READY_EXTRA = "BROADCAST_KEY_SOCKET_READY_EXTRA";
    public static final String BROADCAST_KEY_BRAND_ID = "BROADCAST_KEY_BRAND_ID";
    public static final String BROADCAST_AMS_CONNECTION_UPDATE_ACTION = "BROADCAST_AMS_CONNECTION_UPDATE_ACTION";
    public static final String BROADCAST_AMS_CONNECTION_UPDATE_EXTRA = "BROADCAST_AMS_CONNECTION_UPDATE_EXTRA";
    protected String mBrandId;
    protected long mClockDiff;
    protected long mLastUpdateTime;
    private boolean firstNotificationAfterSubscribe = true;
    protected PreferenceManager mPreferenceManager;
    protected AmsSocketState mSocketState;
    protected final Messaging mController;
    protected ConnectionStateMachine mStateMachine;
    private LocalBroadcastReceiver mCertificateReceiver = null;
    private boolean mIsUpdated = false;
    private boolean mIsAgentDetailsUpdated = false;
    private boolean socketReady = false;

    public AmsConnection(Messaging messagingController, String brandId) {
        this.mController = messagingController;
        this.mPreferenceManager = PreferenceManager.getInstance();
        this.mLastUpdateTime = this.mPreferenceManager.getLongValue("KEY_PREF_LAST_UPDATE_TIME", brandId, 0L);
        this.mBrandId = brandId;
        this.mSocketState = new AmsSocketState();
        this.mCertificateReceiver = new LocalBroadcastReceiver.Builder().addAction("certificate_error_action").build(new LocalBroadcastReceiver.IOnReceive(){

            public void onBroadcastReceived(Context context, Intent intent) {
                AmsConnection.this.mController.mEventsProxy.onError(TaskType.INVALID_CERTIFICATE, "Certificate Error");
            }
        });
        this.initConnectionStateMachine();
    }

    private void initConnectionStateMachine() {
        IConnectionListener connectionListener = this.createConnectionListener();
        InternetInformationProvider internetInformationProvider = this.createInternetInformationProvider();
        MessagingStateMachineInterface controller = this.createMessagingStateMachineInterface();
        this.mStateMachine = new ConnectionStateMachine(controller, internetInformationProvider, (ForegroundServiceInterface)ForegroundService.getInstance(), this.mBrandId, connectionListener);
        this.mStateMachine.setStateMachineExecutor((IStateMachineExecutor)new StateMachineExecutor(this.mStateMachine.getTag(), (IStateMachine)this.mStateMachine));
    }

    @NonNull
    private MessagingStateMachineInterface createMessagingStateMachineInterface() {
        return new MessagingStateMachineInterface(){

            @Override
            public AccountsController getAccountsController() {
                return AmsConnection.this.mController.mAccountsController;
            }

            @Override
            public ConnectionsController getConnectionController() {
                return AmsConnection.this.mController.mConnectionController;
            }

            @Override
            public AmsMessages getAmsMessages() {
                return AmsConnection.this.mController.amsMessages;
            }

            @Override
            public AmsConversations getAmsConversations() {
                return AmsConnection.this.mController.amsConversations;
            }

            @Override
            public AmsDialogs getAmsDialogs() {
                return AmsConnection.this.mController.amsDialogs;
            }

            @Override
            public AmsUsers getAmsUsers() {
                return AmsConnection.this.mController.amsUsers;
            }

            @Override
            public IMessaging getMessagingController() {
                return AmsConnection.this.mController;
            }
        };
    }

    @NonNull
    private InternetInformationProvider createInternetInformationProvider() {
        return new InternetInformationProvider(){

            @Override
            public boolean isNetworkAvailable() {
                return InternetConnectionService.isNetworkAvailable();
            }

            @Override
            public void unregisterToNetworkChanges() {
                Infra.instance.unregisterToNetworkChanges();
            }

            @Override
            public void registerToNetworkChanges() {
                Infra.instance.registerToNetworkChanges();
            }
        };
    }

    @NonNull
    private IConnectionListener createConnectionListener() {
        return new IConnectionListener(){

            @Override
            public void notifyError(TaskType type, String message) {
                AmsConnection.this.mController.mEventsProxy.onError(type, message);
                LocalBroadcast.sendBroadcast((String)AmsConnection.BROADCAST_CONNECTING_TO_SERVER_ERROR);
            }

            @Override
            public void notifyStartConnecting() {
                LocalBroadcast.sendBroadcast((String)AmsConnection.BROADCAST_START_CONNECTING);
                AmsConnectionAnalytics.startConnecting();
                LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("Start connecting for brand: " + AmsConnection.this.mBrandId));
            }

            @Override
            public void notifyStartDisconnecting() {
                AmsConnection.this.onDisconnected();
                AmsConnectionAnalytics.startDisconnecting();
            }

            @Override
            public void notifyDisconnected() {
                AmsConnection.this.onDisconnected();
                AmsConnection.this.mController.amsMessages.mMessageTimeoutQueue.removeAll();
            }

            @Override
            public void notifyConnected() {
                LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("On connected for brand: " + AmsConnection.this.mBrandId));
                AmsConnectionAnalytics.connected();
            }

            @Override
            public void notifyTokenExpired() {
                AmsConnection.this.notifyHostAppTokenExpired();
            }

            @Override
            public void notifyUserExpired() {
                AmsConnection.this.notifyHostAppUserExpired();
            }
        };
    }

    public AmsSocketState registerSocket() {
        String connectionUrl = this.mController.mAccountsController.getConnectionUrl(this.mBrandId);
        String connectionUrlForLogs = this.mController.mAccountsController.getConnectionUrlForLogs(this.mBrandId);
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("Register socket for brand " + this.mBrandId + ", connectionUrl = " + connectionUrlForLogs));
        SocketManager.getInstance().registerToSocketState(connectionUrl, (SocketStateListener)this.mSocketState);
        return this.mSocketState;
    }

    public void unregisterSocketListener() {
        String connectionUrl = this.mController.mAccountsController.getConnectionUrl(this.mBrandId);
        String connectionUrlForLogs = this.mController.mAccountsController.getConnectionUrlForLogs(this.mBrandId);
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("Unregister socket for brand " + this.mBrandId + ", connectionUrl = " + connectionUrlForLogs));
        SocketManager.getInstance().unregisterFromSocketState(connectionUrl, (SocketStateListener)this.mSocketState);
    }

    public void networkLost() {
        LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)("networkLost: brand " + this.mBrandId));
        this.mStateMachine.networkLost();
    }

    public void networkAvailable() {
        LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)("networkAvailable: brand " + this.mBrandId));
        this.mStateMachine.networkAvailable();
    }

    public void moveToForeground() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("moveToForeground for brand " + this.mBrandId));
        this.mStateMachine.moveToForeground();
    }

    public void moveToBackground(long timeoutTimerMs) {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("moveToBackground for brand " + this.mBrandId));
        this.mStateMachine.moveToBackground(timeoutTimerMs);
    }

    public void serviceStarted() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("serviceStarted for brand " + this.mBrandId));
        this.mStateMachine.serviceStarted();
    }

    public void serviceStopped() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("serviceStopped for brand " + this.mBrandId));
        this.mStateMachine.serviceStopped();
    }

    public void startConnecting(boolean connectInBackground, boolean clearToken) {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("startConnecting for brand, connectInBackground = " + connectInBackground));
        if (!this.mStateMachine.isConnecting()) {
            LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("startConnecting for brand clearToken = " + clearToken));
            if (clearToken) {
                this.mController.mAccountsController.setToken(this.mBrandId, null);
            }
            this.mStateMachine.startConnecting(connectInBackground);
        }
    }

    public void startDisconnecting() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("startDisconnecting for brand " + this.mBrandId));
        this.mStateMachine.startDisconnecting();
    }

    protected void onSocketProblem() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("onSocketProblem for brand " + this.mBrandId));
        this.mStateMachine.onSocketProblem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSocketOpen() {
        AmsConnection amsConnection = this;
        synchronized (amsConnection) {
            return this.mStateMachine.isConnected();
        }
    }

    public void setSocketReady(boolean connectedAndUpdating) {
        this.socketReady = connectedAndUpdating;
        this.sendSocketReadyStatus();
    }

    public boolean isSocketReady() {
        return this.socketReady;
    }

    private void sendSocketReadyStatus() {
        Bundle connectionBundle = new Bundle();
        connectionBundle.putBoolean(BROADCAST_KEY_SOCKET_READY_EXTRA, this.isSocketReady());
        connectionBundle.putString(BROADCAST_KEY_BRAND_ID, this.mBrandId);
        LocalBroadcast.sendBroadcast((String)BROADCAST_KEY_SOCKET_READY_ACTION, (Bundle)connectionBundle);
    }

    public boolean isConnecting() {
        return this.mStateMachine.isConnecting();
    }

    public long getClockDiff() {
        return this.mClockDiff;
    }

    public void setClock(long clock) {
        this.mClockDiff = clock;
    }

    public long getLastUpdateTime() {
        return this.mLastUpdateTime;
    }

    protected void getUpdates() {
        LPMobileLog.i((String)TAG, (String)"Socket open - starting updating data...");
        this.initAmsSession();
    }

    private void initAmsSession() {
        new InitAmsSessionCommand(this.mController, this.mBrandId, new ICallback(){

            public void onSuccess(Object value) {
                LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)"getUpdates - Socket connection updates Success");
                AmsConnectionAnalytics.socketReady();
                AmsConnection.this.setSocketReady(true);
            }

            public void onError(Throwable exception) {
                LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("getUpdates - Error. " + exception.getMessage()));
                AmsConnection.this.onSocketProblem();
            }
        }).execute();
    }

    public boolean setLastUpdateTime(long lastUpdateTime) {
        boolean firstTime = false;
        if (this.mLastUpdateTime == 0L) {
            firstTime = true;
        }
        this.mPreferenceManager.setLongValue("KEY_PREF_LAST_UPDATE_TIME", this.mBrandId, lastUpdateTime);
        this.mLastUpdateTime = lastUpdateTime;
        return firstTime;
    }

    public boolean isLastUpdateTimeExists() {
        return this.mLastUpdateTime == 0L;
    }

    public void shutDown(ShutDownCompletionListener listener) {
        this.mStateMachine.shutDown(listener);
    }

    public void init() {
        if (!this.mStateMachine.isInitialized()) {
            this.mStateMachine.setStateMachineExecutor((IStateMachineExecutor)new StateMachineExecutor(this.mStateMachine.getTag(), (IStateMachine)this.mStateMachine));
        }
    }

    private void notifyHostAppTokenExpired() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)(this.mBrandId + ": notifying host app token expired!"));
        this.mController.mEventsProxy.onTokenExpired();
    }

    private void notifyHostAppUserExpired() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)(this.mBrandId + ": notifying host app user expired!"));
        this.mController.mEventsProxy.onUnauthenticatedUserExpired();
    }

    private void notifyHostAppCertificateError(String errorMessage) {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)(this.mBrandId + ": notifying host app invalid certificate"));
        this.mController.mEventsProxy.onError(TaskType.INVALID_CERTIFICATE, errorMessage);
        LocalBroadcast.sendBroadcast((String)BROADCAST_CONNECTING_TO_SERVER_ERROR);
    }

    private void onDisconnected() {
        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)(this.mBrandId + ": disconnected!"));
        this.setIsUpdated(false);
        this.setSocketReady(false);
        this.unregisterSocketListener();
        this.mController.getMessagingEventSubscriptionManager().clearAllSubscriptions();
    }

    public boolean isUpdated() {
        return this.mIsUpdated;
    }

    public void setIsUpdated(boolean isUpdated) {
        if (isUpdated != this.mIsUpdated) {
            LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)(this.mBrandId + ": setIsUpdated = " + isUpdated));
            this.mIsUpdated = isUpdated;
            this.notifyOnConnectionCompleted(this.mIsUpdated);
            if (this.mIsUpdated) {
                this.mController.amsReadController.registerForegroundConnectionReceiver(this.mBrandId);
            }
        }
    }

    private void notifyOnConnectionCompleted(boolean isUpdated) {
        Bundle connectionBundle = new Bundle();
        connectionBundle.putString(BROADCAST_KEY_BRAND_ID, this.mBrandId);
        connectionBundle.putBoolean(BROADCAST_AMS_CONNECTION_UPDATE_EXTRA, isUpdated);
        LocalBroadcast.sendBroadcast((String)BROADCAST_AMS_CONNECTION_UPDATE_ACTION, (Bundle)connectionBundle);
        this.mController.mEventsProxy.onConnectionChanged(isUpdated);
    }

    public boolean isAgentDetailsUpdated() {
        return this.mIsAgentDetailsUpdated;
    }

    public void setAgentDetailsUpdated(boolean updated) {
        this.mIsAgentDetailsUpdated = updated;
    }

    public boolean isFirstNotificationAfterSubscribe() {
        return this.firstNotificationAfterSubscribe;
    }

    public void setFirstNotificationAfterSubscribe(boolean firstNotificationAfterSubscribe) {
        this.firstNotificationAfterSubscribe = firstNotificationAfterSubscribe;
    }

    public class AmsSocketState
    implements SocketStateListener {
        private BaseAmsAccountConnectionCallback callback;

        public void onStateChanged(SocketState state) {
            LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("onStateChanged with state " + state.name()));
            switch (state) {
                case ERROR: 
                case CLOSED: {
                    if (this.callback != null) {
                        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)"Notify error to task callback");
                        this.callback.onTaskError(TaskType.OPEN_SOCKET, new Exception("Open Socket - " + state.name()));
                        this.callback = null;
                        break;
                    }
                    LPMobileLog.i((String)TAG, (String)"Notify socket closed to state machine");
                    AmsConnection.this.onSocketProblem();
                    break;
                }
                case OPEN: {
                    if (this.callback != null) {
                        LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)"Notify socket open successfully to task callback");
                        AmsConnectionAnalytics.openSocketTaskEnd();
                        this.callback.onTaskSuccess();
                        this.callback = null;
                    } else {
                        LPMobileLog.i((String)TAG, (String)"Notify socket open successfully but callback is null - CHECK THIS OUT!");
                    }
                    LocalBroadcast.sendBroadcast((String)AmsConnection.BROADCAST_SOCKET_OPEN_ACTION);
                    AmsConnection.this.getUpdates();
                }
            }
        }

        public void onDisconnected(String reason, int code) {
            LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("onDisconnected, reason " + reason + " code " + code));
            if (code == 0) {
                return;
            }
            if (code == 4407 || code == 4401) {
                AmsConnection.this.startDisconnecting();
                AmsConnection.this.notifyHostAppTokenExpired();
            } else if (code == 1200) {
                AmsConnection.this.startDisconnecting();
                AmsConnection.this.notifyHostAppCertificateError(reason);
            } else {
                LPMobileLog.i((String)TAG, (String)"LOGIN_FLOW", (String)("on disconnect:  code " + code + ", Notify socket closed to state machine"));
                AmsConnection.this.onSocketProblem();
            }
        }

        public void setCallback(BaseAmsAccountConnectionCallback callback) {
            this.callback = callback;
        }
    }
}

