/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.CollectionsUtil;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.tasks.FetchConversationManager;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.utils.ClockUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AmsDialogs
extends BaseDBRepository
implements ShutDown,
Clearable {
    private static final String TAG = "AmsDialogs";
    public static final String KEY_DIALOG_TTR_TIME = "KEY_DIALOG_TTR_TIME";
    public static final String DELAY_TILL_WHEN = "DELAY_TILL_WHEN";
    public static final String DELAY_TILL_WHEN_CHANGED = "DELAY_TILL_WHEN_CHANGED";
    public static final String KEY_DIALOG_ID = "DIALOG_ID";
    public static final String KEY_DIALOG_TARGET_ID = "KEY_DIALOG_TARGET_ID";
    public static final String KEY_DIALOG_STATE = "KEY_DIALOG_STATE";
    public static final String KEY_DIALOG_SHOWED_CSAT = "KEY_DIALOG_SHOWED_CSAT";
    public static final String KEY_DIALOG_ASSIGNED_AGENT = "KEY_DIALOG_ASSIGNED_AGENT";
    public static final String KEY_WELCOME_DIALOG_ID = "KEY_WELCOME_DIALOG_ID";
    protected final Messaging mController;
    @Nullable
    private Dialog mActiveDialog;
    @Nullable
    private String mTempDialogId;
    private Map<String, Dialog> mDialogsByDialogId = new HashMap<String, Dialog>();
    private Map<String, ArrayList<Dialog>> mDialogsByConversationId = new HashMap<String, ArrayList<Dialog>>();
    private HashSet<Integer> acceptedSequenceEvents = new HashSet();

    public AmsDialogs(Messaging controller) {
        super("dialogs");
        this.mController = controller;
    }

    public DataBaseCommand<Dialog> queryActiveDialog(final String brandId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Dialog>(){

            public Dialog query() {
                Cursor cursor;
                ArrayList parsedDialogs;
                Dialog dialog = AmsDialogs.this.mActiveDialog;
                if (dialog != null && dialog.getBrandId().equals(brandId)) {
                    if (dialog.getState() == DialogState.OPEN || dialog.getState() == DialogState.PENDING) {
                        return dialog;
                    }
                    LPMobileLog.e((String)AmsDialogs.TAG, (String)"queryActiveDialog: Impossible case! The active dialog is not open");
                }
                if ((parsedDialogs = AmsDialogs.readDialogs(cursor = AmsDialogs.this.getDB().query(null, "target_id=? and state in (?, ?) order by _id desc", new String[]{brandId, String.valueOf(DialogState.OPEN.ordinal()), String.valueOf(DialogState.PENDING.ordinal())}, null, null, null))).size() == 0) {
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)"queryActiveDialog: Active dialog not found in DB");
                    return null;
                }
                if (parsedDialogs.size() > 1) {
                    LPMobileLog.w((String)AmsDialogs.TAG, (String)"queryActiveDialog: More than 1 open dialogs found in DB");
                }
                AmsDialogs.this.mActiveDialog = (Dialog)parsedDialogs.get(0);
                return AmsDialogs.this.mActiveDialog;
            }
        });
    }

    public DataBaseCommand<Dialog> queryDialogByIds(final String targetId, final String dialogId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Dialog>(){

            public Dialog query() {
                Dialog dialog = (Dialog)AmsDialogs.this.mDialogsByDialogId.get(dialogId);
                if (dialog != null) {
                    return dialog;
                }
                Cursor cursor = AmsDialogs.this.getDB().query(null, "target_id=? and dialog_id=? ", new String[]{targetId, dialogId}, null, null, null);
                return AmsDialogs.this.readDialog(cursor);
            }
        });
    }

    private void addDialog(String brandId, Dialog dialog) {
        if (this.getDialogById(brandId) == null && dialog == null) {
            return;
        }
        this.addDialogToMaps(dialog);
        AmsDialogs.sendUpdateStateIntent(dialog);
    }

    public boolean isDialogActive() {
        Dialog dialog = this.mActiveDialog;
        return dialog != null && dialog.getState() == DialogState.OPEN;
    }

    public void loadOpenDialogsForBrand(final String targetId) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Cursor cursor = AmsDialogs.this.getDB().query(null, "target_id=? and state in (?, ?) order by _id desc limit 1", new String[]{targetId, String.valueOf(DialogState.OPEN.ordinal()), String.valueOf(DialogState.PENDING.ordinal())}, null, null, null);
                ArrayList dialogs = AmsDialogs.readDialogs(cursor);
                for (Dialog dialog : dialogs) {
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)("Setting current dialog for " + targetId + ". dialog id = " + dialog.getDialogId()));
                    AmsDialogs.this.addDialog(targetId, dialog);
                }
            }
        });
    }

    private Dialog readDialog(Cursor cursor) {
        Dialog result = null;
        ArrayList<Dialog> dialogs = AmsDialogs.readDialogs(cursor);
        if (dialogs.size() == 1) {
            result = dialogs.get(0);
        }
        return result;
    }

    @NonNull
    private static ArrayList<Dialog> readDialogs(Cursor cursor) {
        ArrayList<Dialog> dialogs = new ArrayList<Dialog>();
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    do {
                        dialogs.add(new Dialog(cursor));
                    } while (cursor.moveToNext());
                }
            }
            catch (Exception e) {
                LPMobileLog.e((String)TAG, (Throwable)e);
            }
            finally {
                cursor.close();
            }
        }
        return dialogs;
    }

    public static HashMap<String, Dialog> extractDialogsToMap(ConversationData data) {
        ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
        HashMap<String, Dialog> dialogHashMap = new HashMap<String, Dialog>(dialogs.size());
        for (Dialog dialog : dialogs) {
            dialogHashMap.put(dialog.getDialogId(), dialog);
        }
        return dialogHashMap;
    }

    public static ArrayList<Dialog> extractDialogs(ConversationData data) {
        ArrayList<Dialog> result = new ArrayList<Dialog>();
        if (data.dialogs == null) {
            Dialog dialog = new Dialog(data);
            result.add(dialog);
        } else if (data.dialogs.length > 0) {
            for (DialogData dialogData : data.dialogs) {
                result.add(new Dialog(dialogData, data));
            }
        } else {
            result.add(new Dialog(data));
        }
        if (result.size() > 1) {
            LPMobileLog.d((String)TAG, (String)("Before sort: " + result));
            Collections.sort(result, new Comparator<Dialog>(){

                @Override
                public int compare(Dialog dialog1, Dialog dialog2) {
                    long timeDiff = dialog1.getStartTimestamp() - dialog2.getStartTimestamp();
                    if (timeDiff > 0L) {
                        return 1;
                    }
                    if (timeDiff < 0L) {
                        return -1;
                    }
                    return 0;
                }
            });
            LPMobileLog.d((String)TAG, (String)("After sort: " + result));
        }
        return result;
    }

    @Nullable
    public static Dialog getOpenDialog(ArrayList<Dialog> dialogs) {
        if (dialogs.size() == 0) {
            LPMobileLog.e((String)TAG, (String)"getOpenDialog: Got an empty dialogs list");
            return null;
        }
        ArrayList filtered = CollectionsUtil.filter(dialogs, (CollectionsUtil.Predicate)new CollectionsUtil.Predicate<Dialog>(){

            public boolean test(Dialog dialog) {
                return dialog.isOpenOrPending();
            }
        });
        if (filtered.size() == 0) {
            LPMobileLog.e((String)TAG, (String)"getOpenDialog: Missing open dialog in conversation");
            return null;
        }
        if (filtered.size() > 1) {
            LPMobileLog.e((String)TAG, (String)"getOpenDialog: Too many simultaneous open dialogs found in conversation: ");
        }
        return (Dialog)filtered.get(0);
    }

    public void updateDialogs(ConversationData data) {
        ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
        for (Dialog dialog : dialogs) {
            this.updateDialogDatabase(dialog, data);
        }
    }

    public void updateDialogDatabase(Dialog updatedDialog, ConversationData data) {
        final Dialog dialog = this.getDialogById(updatedDialog.getDialogId());
        if (dialog == null) {
            return;
        }
        final ContentValues dialogValues = new ContentValues();
        DialogState dialogState = updatedDialog.getState();
        if (dialog.getState() != dialogState) {
            dialog.setState(dialogState);
            dialogValues.put("state", Integer.valueOf(dialogState != null ? dialogState.ordinal() : -1));
        }
        if (dialog.getConversationTTRType() != updatedDialog.getConversationTTRType()) {
            dialog.setConversationTTRType(updatedDialog.getConversationTTRType());
            switch (updatedDialog.getConversationTTRType()) {
                case URGENT: {
                    this.mController.mEventsProxy.onConversationMarkedAsUrgent();
                    break;
                }
                case NORMAL: {
                    this.mController.mEventsProxy.onConversationMarkedAsNormal();
                }
            }
            dialogValues.put("ttr_type", Integer.valueOf(updatedDialog.getConversationTTRType().ordinal()));
        }
        if (dialog.getRequestId() != data.requestId) {
            dialog.setRequestId(data.requestId);
            dialogValues.put("request_id", Long.valueOf(data.requestId));
        }
        if (!TextUtils.equals((CharSequence)dialog.getConversationId(), (CharSequence)dialog.getConversationId())) {
            dialog.setConversationId(updatedDialog.getConversationId());
            dialogValues.put("conversation_id", updatedDialog.getConversationId());
        }
        String assignedAgentId = updatedDialog.getAssignedAgentId();
        if (!TextUtils.equals((CharSequence)dialog.getAssignedAgentId(), (CharSequence)assignedAgentId)) {
            dialog.setAssignedAgentId(assignedAgentId);
            dialogValues.put("assigned_agent_id", assignedAgentId);
        }
        if (dialog.getUnreadMessages() != updatedDialog.getUnreadMessages()) {
            dialog.setUnreadMessages(updatedDialog.getUnreadMessages());
            dialogValues.put("unread_msg_count", Integer.valueOf(updatedDialog.getUnreadMessages()));
            AmsDialogs.sendUpdateUnreadMsgIntent(dialog);
        }
        if (dialog.getStartTimestamp() != updatedDialog.getStartTimestamp()) {
            dialog.setStartTimestamp(updatedDialog.getStartTimestamp());
            dialogValues.put("start_timestamp", Long.valueOf(updatedDialog.getStartTimestamp()));
        }
        if (dialogValues.size() > 0) {
            final String dialogId = dialog.getDialogId();
            dialogValues.put("dialog_id", dialogId);
            dialogValues.put("dialog_type", dialog.getDialogType().toString());
            DataBaseExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    AmsDialogs.this.getDB().update(dialogValues, "dialog_id=?", new String[]{String.valueOf(dialogId)});
                    AmsDialogs.sendUpdateStateIntent(dialog);
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)"MULTI_DIALOG_FLOW", (String)("Updated new dialog's data in DB. Dialog: " + dialog));
                }
            });
        }
    }

    public DataBaseCommand<Void> deleteDialogById(final String dialogIdToDelete) {
        if (!TextUtils.isEmpty((CharSequence)dialogIdToDelete) && dialogIdToDelete.equals(this.mTempDialogId)) {
            this.mTempDialogId = null;
        }
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                AmsDialogs.this.getDB().removeAll("dialog_id=?", new String[]{String.valueOf(dialogIdToDelete)});
                LPMobileLog.d((String)AmsDialogs.TAG, (String)"Finished removing dialog");
                return null;
            }
        });
    }

    public void createPendingDialog(String targetId, String brandId, String tempDialogId, String tempConversationId, long requestId) {
        this.createDialog(targetId, brandId, tempDialogId, tempConversationId, DialogState.PENDING, requestId);
    }

    public void createQueuedDialog(String targetId, String brandId, String tempDialogId, String tempConversationId, long requestId) {
        this.createDialog(targetId, brandId, tempDialogId, tempConversationId, DialogState.QUEUED, requestId);
    }

    private void createDialog(String targetId, String brandId, String tempDialogId, String tempConversationId, DialogState dialogState, long requestId) {
        this.mTempDialogId = tempDialogId;
        final Dialog dialog = new Dialog(targetId, brandId);
        dialog.setConversationId(tempConversationId);
        dialog.setDialogId(tempDialogId);
        dialog.setChannelType(MultiDialog.ChannelType.MESSAGING);
        dialog.setDialogType(DialogType.MAIN);
        dialog.setState(dialogState);
        dialog.setConversationTTRType(TTRType.NORMAL);
        dialog.setRequestId(requestId);
        this.addDialogToMaps(dialog);
        final ContentValues dialogValues = new ContentValues();
        dialogValues.put("dialog_type", dialog.getDialogType().toString());
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                dialogValues.put("dialog_id", dialog.getDialogId());
                dialogValues.put("conversation_id", dialog.getConversationId());
                dialogValues.put("brand_id", dialog.getBrandId());
                dialogValues.put("target_id", dialog.getTargetId());
                dialogValues.put("state", Integer.valueOf(dialog.getState().ordinal()));
                dialogValues.put("ttr_type", Integer.valueOf(dialog.getConversationTTRType().ordinal()));
                dialogValues.put("assigned_agent_id", "");
                dialogValues.put("request_id", Long.valueOf(dialog.getRequestId()));
                dialogValues.put("last_server_sequence", Long.valueOf(0L));
                dialogValues.put("unread_msg_count", Integer.valueOf(-1));
                dialogValues.put("start_timestamp", Long.valueOf(System.currentTimeMillis()));
                AmsDialogs.this.getDB().insert(dialogValues);
                LPMobileLog.d((String)AmsDialogs.TAG, (String)("create New Pending Dialog - temp ID = " + dialog.getDialogId()));
                AmsDialogs.sendUpdateStateIntent(dialog);
            }
        });
    }

    public void updateLastServerSequenceByDialogId(String dialogId, int serverSequence) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null && dialog.getLastServerSequence() != serverSequence) {
            boolean updated = false;
            long lastServerSequence = dialog.getLastServerSequence();
            if (lastServerSequence + 1L == (long)serverSequence) {
                dialog.setLastServerSequence(serverSequence);
                LPMobileLog.d((String)TAG, (String)("Got an expected sequence!! last sequence = " + lastServerSequence + " (1) , new current sequence : " + serverSequence));
                updated = true;
            } else {
                LPMobileLog.d((String)TAG, (String)("Failed! Got an unexpected sequence!! last sequence = " + lastServerSequence + " (1),  new unexpected sequence : " + serverSequence));
                this.acceptedSequenceEvents.add(serverSequence);
            }
            updated = this.updateNextWaitingSequences(dialog, updated);
            if (updated) {
                LPMobileLog.d((String)TAG, (String)("Running update last server sequence in db command. new last sequence = " + dialog.getLastServerSequence()));
                this.updateSequenceInDb(dialog);
            }
        }
    }

    private boolean updateNextWaitingSequences(Dialog dialog, boolean updated) {
        int nextSequence = dialog.getLastServerSequence() + 1;
        HashSet<Integer> sequencesToRemove = new HashSet<Integer>();
        while (this.acceptedSequenceEvents.contains(nextSequence)) {
            LPMobileLog.d((String)TAG, (String)("Waited sequence " + nextSequence + " this is the new last server sequence!"));
            sequencesToRemove.add(nextSequence);
            dialog.setLastServerSequence(nextSequence);
            ++nextSequence;
            updated = true;
        }
        if (!sequencesToRemove.isEmpty()) {
            this.acceptedSequenceEvents.removeAll(sequencesToRemove);
        }
        return updated;
    }

    private void removeOldWaitingSequences(int serverSequence) {
        HashSet<Integer> sequencesToRemove = new HashSet<Integer>();
        for (Integer sequence : this.acceptedSequenceEvents) {
            if (sequence > serverSequence) continue;
            LPMobileLog.d((String)TAG, (String)("Waited sequence " + sequence + " deleted after query messages!"));
            sequencesToRemove.add(sequence);
        }
        if (!sequencesToRemove.isEmpty()) {
            this.acceptedSequenceEvents.removeAll(sequencesToRemove);
        }
    }

    private void updateSequenceInDb(final Dialog dialog) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentValues dialogValues = new ContentValues();
                int serverSequence = dialog.getLastServerSequence();
                String dialogId = dialog.getDialogId();
                dialogValues.put("last_server_sequence", Integer.valueOf(serverSequence));
                String whereClause = "dialog_id=?";
                String[] whereArgs = new String[]{dialogId};
                int updatedRows = AmsDialogs.this.getDB().update(dialogValues, "dialog_id=?", whereArgs);
                LPMobileLog.d((String)AmsDialogs.TAG, (String)("update sequence " + serverSequence + " for " + dialogId + " without gap. updated rows = " + updatedRows));
                if (dialog != null) {
                    AmsDialogs.sendUpdateStateIntent(dialog);
                }
            }
        });
    }

    public DataBaseCommand<Boolean> updateLastServerSequenceByDialogId(String dialogId, int serverSequence, int sequenceGap, boolean updateUI) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null) {
            long lastServerSequence = dialog.getLastServerSequence();
            if (lastServerSequence + (long)sequenceGap == (long)serverSequence) {
                dialog.setLastServerSequence(serverSequence);
                LPMobileLog.d((String)TAG, (String)("Got an expected sequence!! last sequence = " + lastServerSequence + " gap = " + sequenceGap + ", new current sequence : " + serverSequence));
                this.removeOldWaitingSequences(serverSequence);
            } else {
                LPMobileLog.d((String)TAG, (String)("Failed! Got an unexpected sequence!! last sequence = " + lastServerSequence + " gap = " + sequenceGap + ", new unexpected sequence : " + serverSequence));
                return null;
            }
        }
        return this.getUpdateSequenceInDb(dialogId, serverSequence, sequenceGap, updateUI, dialog);
    }

    @NonNull
    private DataBaseCommand<Boolean> getUpdateSequenceInDb(final String dialogId, final int serverSequence, final int sequenceGap, final boolean updateUI, final Dialog dialog) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Boolean>(){

            public Boolean query() {
                ContentValues dialogValues = new ContentValues();
                dialogValues.put("last_server_sequence", Integer.valueOf(serverSequence));
                String whereClause = "dialog_id" + "=? and " + "last_server_sequence" + "+" + sequenceGap + " = " + serverSequence;
                Object[] whereArgs = new String[]{dialogId};
                int updatedRows = AmsDialogs.this.getDB().update(dialogValues, whereClause, (String[])whereArgs);
                LPMobileLog.d((String)AmsDialogs.TAG, (String)("update sequence " + serverSequence + " for " + dialogId + ". gap = " + sequenceGap + ". updated rows = " + updatedRows));
                if (dialog != null && updateUI) {
                    AmsDialogs.sendUpdateStateIntent(dialog);
                }
                if (updatedRows > 0) {
                    return true;
                }
                Cursor c = AmsDialogs.this.getDB().rawQuery("select last_server_sequence from dialogs where dialog_id =?", whereArgs);
                if (c.moveToFirst()) {
                    int lastServerSequenceInDb = c.getInt(c.getColumnIndex("last_server_sequence"));
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)("No rows updated! last sequence stored in db : " + lastServerSequenceInDb));
                }
                c.close();
                return false;
            }
        });
    }

    public DataBaseCommand<Dialog> updateCurrentDialogServerId(String tempDialogId, ConversationData data) {
        final Dialog dialog = this.getDialogById(tempDialogId);
        this.removeDialog(data.targetId, tempDialogId);
        dialog.setState(DialogState.parse(data.state));
        dialog.setStartTimestamp(data.startTs);
        dialog.setDialogId(DialogData.extractDialogId(data));
        dialog.setConversationId(data.conversationId);
        dialog.setConversationTTRType(data.conversationTTRType);
        dialog.setRequestId(data.requestId);
        dialog.setAssignedAgentId(data.getAssignedAgentId());
        this.addDialogToMaps(dialog);
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Dialog>(){

            public Dialog query() {
                AmsDialogs.this.getDB().insert(AmsDialogs.getContentValues(dialog));
                AmsDialogs.sendUpdateStateIntent(dialog);
                LPMobileLog.d((String)AmsDialogs.TAG, (String)"Finished updating dialog with server id");
                return dialog;
            }
        });
    }

    public DataBaseCommand<Dialog> updateClosedDialog(ConversationData conversationData, boolean shouldUpdateUI) {
        ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(conversationData);
        Dialog dialog = dialogs.get(0);
        return this.updateClosedDialog(conversationData, dialog, shouldUpdateUI);
    }

    public DataBaseCommand<Dialog> updateClosedDialog(ConversationData conversationData, final Dialog dialog, boolean shouldUpdateUI) {
        LPMobileLog.d((String)TAG, (String)"MULTI_DIALOG_FLOW", (String)("updateClosedDialog: Closing dialog: " + dialog));
        dialog.setState(DialogState.CLOSE);
        String brandId = dialog.getTargetId();
        shouldUpdateUI = this.shouldNotifyUIDialogClosed(dialog.getCloseReason(), brandId, dialog.getEndTimestamp(), shouldUpdateUI);
        final CSAT.CSAT_SHOW_STATUS csatShowStatus = AmsConversations.calculateShowedCsat(conversationData, shouldUpdateUI);
        Dialog dialogToClose = this.mDialogsByDialogId.get(dialog.getDialogId());
        if (dialogToClose != null) {
            if (dialogToClose.getState() != DialogState.CLOSE) {
                LPMobileLog.d((String)TAG, (String)"MULTI_DIALOG_FLOW", (String)("Closing dialog " + dialogToClose.getDialogId() + ", close reason:" + (Object)((Object)dialog.getCloseReason()) + ", close ts:" + dialog.getEndTimestamp()));
                dialogToClose.getTTRManager().cancelAll();
                dialogToClose.setCloseReason(dialog.getCloseReason());
                dialogToClose.setEndTimestamp(dialog.getEndTimestamp());
                dialogToClose.setAssignedAgentId(dialog.getAssignedAgentId());
                dialogToClose.setState(DialogState.CLOSE);
            }
            dialogToClose.setShowedCSAT(csatShowStatus);
        }
        if (this.mActiveDialog != null && this.mActiveDialog.getDialogId().equals(dialog.getDialogId())) {
            LPMobileLog.d((String)TAG, (String)"MULTI_DIALOG_FLOW", (String)("updateClosedDialog: Cleaning active dialog: " + this.mActiveDialog));
            this.mActiveDialog = null;
        }
        final boolean finalUpdateUI = shouldUpdateUI;
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Dialog>(){

            public Dialog query() {
                Cursor cursor = AmsDialogs.this.getDB().query(null, "dialog_id=?", new String[]{dialog.getDialogId()}, null, null, null);
                Dialog result = AmsDialogs.this.readDialog(cursor);
                if (result == null) {
                    LPMobileLog.i((String)AmsDialogs.TAG, (String)("Old dialog " + dialog.getDialogId() + " does not exist in DB. creating new one closed conversation, close reason:" + (Object)((Object)dialog.getCloseReason()) + ", close ts:" + dialog.getEndTimestamp()));
                    AmsDialogs.this.getDB().insert(AmsDialogs.getContentValues(dialog));
                } else if (result.getState() != DialogState.CLOSE) {
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)"Closing current dialog.. ");
                    result.setState(DialogState.CLOSE);
                    result.setCloseReason(dialog.getCloseReason());
                    result.setEndTimestamp(dialog.getEndTimestamp());
                    result.setAssignedAgentId(dialog.getAssignedAgentId());
                    result.setShowedCSAT(csatShowStatus);
                    AmsDialogs.this.getDB().update(AmsDialogs.getContentValues(dialog), "dialog_id=?", new String[]{String.valueOf(dialog.getDialogId())});
                    if (finalUpdateUI) {
                        AmsDialogs.sendUpdateCSATDialogIntent(dialog);
                    }
                    AmsDialogs.sendDialogClosedIntent(dialog, dialog.getAssignedAgentId());
                } else {
                    if (dialog.isShowedCSAT() != csatShowStatus) {
                        dialog.setShowedCSAT(csatShowStatus);
                        AmsDialogs.this.getDB().update(AmsDialogs.getContentValues(dialog), "dialog_id=?", new String[]{String.valueOf(dialog.getDialogId())});
                    }
                    if (finalUpdateUI) {
                        AmsDialogs.sendUpdateCSATDialogIntent(dialog);
                    }
                    AmsDialogs.sendDialogClosedIntent(dialog, dialog.getAssignedAgentId());
                    return null;
                }
                return dialog;
            }
        });
    }

    private boolean shouldNotifyUIDialogClosed(CloseReason closeReason, String brandId, long closeTS, boolean updateUI) {
        if (updateUI) {
            if (this.isAutoClose(closeReason)) {
                LPMobileLog.d((String)TAG, (String)"Updating closed dialog. Close Reason = System. do not update UI.");
                updateUI = false;
            } else {
                updateUI = this.checkExpiry(brandId, closeTS, updateUI);
            }
        }
        return updateUI;
    }

    private boolean isAutoClose(CloseReason closeReason) {
        return closeReason == CloseReason.TIMEOUT || closeReason == CloseReason.SYSTEM;
    }

    private boolean checkExpiry(String brandId, long closeTimestamp, boolean updateUI) {
        int expirationInMinutes = Configuration.getInteger((int)R.integer.csatSurveyExpirationInMinutes);
        if (expirationInMinutes != 0) {
            long expirationInMillis;
            long endTime;
            long clockDiff = this.mController.mConnectionController.getClockDiff(brandId);
            long now = System.currentTimeMillis();
            if (now - (endTime = clockDiff + closeTimestamp) > (expirationInMillis = TimeUnit.MINUTES.toMillis(expirationInMinutes))) {
                LPMobileLog.d((String)TAG, (String)("Closing dialog - time expired for CSAT. endTime = " + endTime + " expirationInMinutes = " + expirationInMinutes));
                updateUI = false;
            }
        }
        return updateUI;
    }

    private static void sendUpdateStateIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        extras.putInt(KEY_DIALOG_STATE, dialog.getState().ordinal());
        extras.putString(KEY_DIALOG_ASSIGNED_AGENT, dialog.getAssignedAgentId());
        LPMobileLog.d((String)TAG, (String)("Sending dialog update with : " + extras));
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_DIALOG", (Bundle)extras);
    }

    protected static void sendDialogClosedIntent(Dialog dialog, String assignedAgentId) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        extras.putString(KEY_DIALOG_ASSIGNED_AGENT, assignedAgentId);
        LPMobileLog.d((String)TAG, (String)("Sending dialog autoClosed update with : " + extras));
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_DIALOG_CLOSED", (Bundle)extras);
    }

    protected static void sendUpdateCSATDialogIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        extras.putInt(KEY_DIALOG_STATE, dialog.getState().ordinal());
        extras.putString(KEY_DIALOG_ASSIGNED_AGENT, dialog.getAssignedAgentId());
        extras.putInt(KEY_DIALOG_SHOWED_CSAT, dialog.isShowedCSAT().getValue());
        LPMobileLog.d((String)TAG, (String)("Sending dialog CSAT update with : " + extras));
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_CSAT_DIALOG", (Bundle)extras);
    }

    protected static void sendUpdateNewDialogIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        extras.putString(KEY_DIALOG_ID, dialog.getDialogId());
        LPMobileLog.d((String)TAG, (String)("Sending dialog update with : " + extras));
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_NEW_DIALOG_MSG", (Bundle)extras);
    }

    protected static void sendUpdateUnreadMsgIntent(Dialog dialog) {
        Bundle extras = new Bundle();
        extras.putString(KEY_DIALOG_TARGET_ID, dialog.getTargetId());
        LPMobileLog.d((String)TAG, (String)("Sending dialog update with : " + extras));
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_DIALOG_UNREAD_MSG", (Bundle)extras);
    }

    private static ContentValues getContentValues(Dialog dialog) {
        ContentValues dialogValues = new ContentValues();
        dialogValues.put("conversation_id", dialog.getConversationId());
        dialogValues.put("dialog_id", dialog.getDialogId());
        dialogValues.put("dialog_type", dialog.getDialogType().toString());
        dialogValues.put("brand_id", dialog.getBrandId());
        dialogValues.put("target_id", dialog.getTargetId());
        dialogValues.put("state", Integer.valueOf(dialog.getState() != null ? dialog.getState().ordinal() : -1));
        dialogValues.put("ttr_type", Integer.valueOf(dialog.getConversationTTRType() != null ? dialog.getConversationTTRType().ordinal() : -1));
        dialogValues.put("assigned_agent_id", dialog.getAssignedAgentId());
        dialogValues.put("request_id", Long.valueOf(dialog.getRequestId()));
        dialogValues.put("close_reason", Integer.valueOf(dialog.getCloseReason() != null ? dialog.getCloseReason().ordinal() : -1));
        dialogValues.put("start_timestamp", Long.valueOf(dialog.getStartTimestamp()));
        dialogValues.put("end_timestamp", Long.valueOf(dialog.getEndTimestamp()));
        dialogValues.put("last_server_sequence", Integer.valueOf(dialog.getLastServerSequence()));
        dialogValues.put("csat_status", Integer.valueOf(dialog.isShowedCSAT().getValue()));
        dialogValues.put("unread_msg_count", Integer.valueOf(dialog.getUnreadMessages()));
        return dialogValues;
    }

    public void resetEffectiveTTR(String targetId) {
        Dialog dialog = this.getDialogById(targetId);
        if (dialog != null) {
            dialog.getTTRManager().resetEffectiveTTR();
        }
    }

    public DataBaseCommand<Dialog> queryDialogById(final String dialogId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Dialog>(){

            public Dialog query() {
                Cursor c = AmsDialogs.this.getDB().rawQuery("select * from dialogs where dialog_id = ?", new Object[]{dialogId});
                Dialog dialog = null;
                if (c != null) {
                    dialog = AmsDialogs.this.readDialog(c);
                }
                return dialog;
            }
        });
    }

    protected void addDialogToMaps(Dialog dialog) {
        if (!dialog.isClosed()) {
            this.setActiveDialog(dialog);
        }
        this.cacheDialog(dialog);
        LPMobileLog.d((String)TAG, (String)("Putting dialog in dialogs ,ap. Dialog ID: " + dialog.getDialogId() + " targetId: " + dialog.getTargetId()));
    }

    private void removeDialog(String targetId, String dialogId) {
        LPMobileLog.d((String)TAG, (String)("Removing dialog Id: " + dialogId + " target Id: " + targetId));
        Dialog dialog = this.mActiveDialog;
        if (dialog != null && dialog.getDialogId().equals(dialogId)) {
            LPMobileLog.d((String)TAG, (String)"MULTI_DIALOG_FLOW", (String)("removeDialog: Cleaning active dialog: " + this.mActiveDialog));
            this.mActiveDialog = null;
        }
        this.mDialogsByDialogId.remove(dialogId);
    }

    private void removeAllDialogsFromMaps(String targetId) {
        if (this.mActiveDialog != null && this.mActiveDialog.isOpenOrPending()) {
            LPMobileLog.w((String)TAG, (String)("removeAllDialogsFromMaps: current dialog from brand " + targetId + " is active. Did not remove"));
            return;
        }
        this.mDialogsByDialogId.clear();
        this.mActiveDialog = null;
        LPMobileLog.d((String)TAG, (String)"removeAllDialogsFromMaps: Removing all dialogs");
    }

    public DataBaseCommand<Integer> clearClosedDialogs(final String targetId) {
        this.removeAllDialogsFromMaps(targetId);
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){
            String whereString = "target_id=? and state=?";
            String[] whereArgs = new String[]{targetId, String.valueOf(DialogState.CLOSE.ordinal())};

            public Integer query() {
                return AmsDialogs.this.getDB().removeAll(this.whereString, this.whereArgs);
            }
        });
    }

    public DataBaseCommand<Integer> clearAllDialogs(final String targetId) {
        this.removeAllDialogsFromMaps(targetId);
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){
            String whereString = "target_id=?";
            String[] whereArgs = new String[]{targetId};

            public Integer query() {
                return AmsDialogs.this.getDB().removeAll(this.whereString, this.whereArgs);
            }
        });
    }

    @Nullable
    public String getTempDialogId() {
        return this.mTempDialogId;
    }

    @Nullable
    public Dialog getActiveDialog() {
        Dialog dialog = this.mActiveDialog;
        if (dialog != null && dialog.isClosed()) {
            dialog = null;
        }
        return dialog;
    }

    @Nullable
    public Dialog getDialogById(String dialogId) {
        return this.mDialogsByDialogId.get(dialogId);
    }

    public void getDialogByIdAsync(String dialogId, final ICallback<Dialog, Exception> callback) {
        Dialog dialog = this.mDialogsByDialogId.get(dialogId);
        if (dialog != null) {
            callback.onSuccess((Object)dialog);
        } else {
            this.queryDialogById(dialogId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Dialog>(){

                public void onResult(Dialog dialog) {
                    if (dialog != null) {
                        callback.onSuccess((Object)dialog);
                    } else {
                        callback.onError((Throwable)new Exception("Dialog not found"));
                    }
                }
            }).execute();
        }
    }

    public ArrayList<Dialog> getDialogsByConversationId(String conversationId) {
        ArrayList<Dialog> dialogs = new ArrayList<Dialog>();
        if (conversationId == null) {
            return dialogs;
        }
        for (Map.Entry<String, Dialog> dialogEntry : this.mDialogsByDialogId.entrySet()) {
            Dialog dialogEntryValue = dialogEntry.getValue();
            String dialogEntryConversationId = dialogEntryValue.getConversationId();
            if (!conversationId.equals(dialogEntryConversationId)) continue;
            dialogs.add(dialogEntryValue);
        }
        return dialogs;
    }

    public DataBaseCommand<Dialog> fetchPreviousDialog(final String targetId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Dialog>(){

            public Dialog query() {
                Cursor c = AmsDialogs.this.getNextDialogToFetch(targetId);
                Dialog dialog = null;
                if (c != null && c.moveToFirst()) {
                    dialog = AmsDialogs.this.readDialog(c);
                    AmsDialogs.this.cacheDialog(dialog);
                    FetchConversationManager conversationManager = new FetchConversationManager(AmsDialogs.this.mController);
                    Conversation conversation = (Conversation)AmsDialogs.this.mController.amsConversations.queryConversationById(dialog.getConversationId()).executeSynchronously();
                    ArrayList dialogs = (ArrayList)AmsDialogs.this.mController.amsDialogs.queryDialogsByConversationId(conversation.getConversationId()).executeSynchronously();
                    conversationManager.fetchConversation(conversation, dialogs);
                }
                return dialog;
            }
        });
    }

    private void cacheDialog(Dialog dialog) {
        this.mDialogsByDialogId.put(dialog.getDialogId(), dialog);
    }

    private Cursor getNextDialogToFetch(String targetId) {
        return this.getDB().rawQuery("select * from dialogs where target_id = ? and last_server_sequence = -1 order by start_timestamp DESC limit 1", new Object[]{targetId});
    }

    public void setUpdateRequestInProgress(final String dialogId, final int numUpdateInProgress) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null) {
            LPMobileLog.d((String)TAG, (String)("adding update request in progress for dialog ID: " + dialogId + ", requests in progress: " + numUpdateInProgress));
            dialog.setUpdateInProgress(numUpdateInProgress);
        }
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                LPMobileLog.d((String)AmsDialogs.TAG, (String)("update request for dialog in DB: " + dialogId + ", numUpdateInProgress: " + numUpdateInProgress));
                ContentValues dialogValues = new ContentValues();
                dialogValues.put("concurrent_requests_counter", Integer.valueOf(numUpdateInProgress));
                AmsDialogs.this.getDB().update(dialogValues, "dialog_id=?", new String[]{String.valueOf(dialogId)});
            }
        });
    }

    public void addUpdateRequestInProgress(String dialogId) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null) {
            int mUpdateInProgress = dialog.getUpdateInProgress() + 1;
            LPMobileLog.d((String)TAG, (String)("adding update request in progress for dialog: " + dialogId + ", requests in progress: " + mUpdateInProgress));
            dialog.setUpdateInProgress(mUpdateInProgress);
        }
        this.updateRequestsInProgress(dialogId, 1);
    }

    public void removeUpdateRequestInProgress(String dialogId) {
        Dialog dialog = this.getDialogById(dialogId);
        if (dialog != null) {
            int mUpdateInProgress = dialog.getUpdateInProgress() - 1;
            LPMobileLog.d((String)TAG, (String)("removing update request for dialog ID: " + dialogId + ", requests in progress: " + mUpdateInProgress));
            dialog.setUpdateInProgress(mUpdateInProgress);
        }
        this.updateRequestsInProgress(dialogId, -1);
    }

    private void updateRequestsInProgress(final String dialogId, final int addValue) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (Cursor c = null;){
                    c = AmsDialogs.this.getDB().query(new String[]{"concurrent_requests_counter"}, "dialog_id = ? ", new String[]{dialogId}, null, null, null);
                    int updateInProgress = 0;
                    if (c != null && c.moveToFirst()) {
                        updateInProgress = c.getInt(c.getColumnIndex("concurrent_requests_counter"));
                    }
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)("update request for dialog in DB: " + dialogId + ", requests in progress: " + updateInProgress + " added value = " + addValue));
                    ContentValues dialogValues = new ContentValues();
                    dialogValues.put("concurrent_requests_counter", Integer.valueOf(updateInProgress + addValue));
                    AmsDialogs.this.getDB().update(dialogValues, "conversation_id=?", new String[]{String.valueOf(dialogId)});
                }
            }
        });
    }

    public void updateDialogState(String targetId, final String dialogId, final DialogState state) {
        Dialog dialog = this.getActiveDialog();
        if (dialog != null) {
            LPMobileLog.d((String)TAG, (String)("update dialog state, new state = " + (Object)((Object)state)));
            dialog.setState(state);
        }
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                LPMobileLog.d((String)AmsDialogs.TAG, (String)("update new state for dialog in DB: " + dialogId + ", state: " + (Object)((Object)state)));
                ContentValues dialogValues = new ContentValues();
                dialogValues.put("state", Integer.valueOf(state.ordinal()));
                AmsDialogs.this.getDB().update(dialogValues, "dialog_id=?", new String[]{String.valueOf(dialogId)});
            }
        });
    }

    public void clear() {
        for (Dialog dialog : this.mDialogsByDialogId.values()) {
            dialog.getTTRManager().clear();
        }
        this.acceptedSequenceEvents.clear();
        this.mDialogsByDialogId.clear();
        this.mActiveDialog = null;
    }

    public void shutDown() {
        for (Dialog dialog : this.mDialogsByDialogId.values()) {
            dialog.getTTRManager().shutDown();
        }
    }

    public void createNewCurrentDialog(final Dialog dialog) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AmsDialogs.this.getDB().insert(AmsDialogs.getContentValues(dialog));
                LPMobileLog.i((String)AmsDialogs.TAG, (String)("Created new current dialog with ID: " + dialog.getDialogId()));
                AmsDialogs.sendUpdateStateIntent(dialog);
                AmsDialogs.sendUpdateNewDialogIntent(dialog);
            }
        });
    }

    public void createDummyDialogForWelcomeMessage(String brandId, String dummyConversationId, String dummyDialogId, long lastMessageSequence, long startTime) {
        DataBaseExecutor.execute(() -> {
            ContentValues dialogValues = new ContentValues();
            dialogValues.put("brand_id", brandId);
            dialogValues.put("target_id", brandId);
            dialogValues.put("dialog_id", dummyDialogId);
            dialogValues.put("conversation_id", dummyConversationId);
            dialogValues.put("state", Integer.valueOf(DialogState.LOCKED.ordinal()));
            dialogValues.put("ttr_type", Integer.valueOf(TTRType.NORMAL.ordinal()));
            dialogValues.put("assigned_agent_id", "");
            dialogValues.put("request_id", Integer.valueOf(-1));
            dialogValues.put("last_server_sequence", Long.valueOf(lastMessageSequence));
            dialogValues.put("unread_msg_count", Integer.valueOf(-1));
            dialogValues.put("start_timestamp", Long.valueOf(startTime));
            this.getDB().insert(dialogValues);
            LPMobileLog.d((String)TAG, (String)("created dummy dialog for first message- startTime = " + startTime));
        });
    }

    public DataBaseCommand<ArrayList<Dialog>> queryOpenDialogsOfConversation(final String conversationId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<ArrayList<Dialog>>(){

            public ArrayList<Dialog> query() {
                Cursor cursor = AmsDialogs.this.getDB().query(null, "conversation_id=? and state in (?, ?) order by _id desc", new String[]{conversationId, String.valueOf(DialogState.OPEN.ordinal()), String.valueOf(DialogState.PENDING.ordinal())}, null, null, null);
                ArrayList dialogs = AmsDialogs.readDialogs(cursor);
                return dialogs;
            }
        });
    }

    public DataBaseCommand<ArrayList<Dialog>> queryDialogsByConversationId(final String conversationId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<ArrayList<Dialog>>(){

            public ArrayList<Dialog> query() {
                Cursor c = AmsDialogs.this.getDB().rawQuery("select * from dialogs where conversation_id = ?", new Object[]{conversationId});
                ArrayList dialogs = null;
                if (c != null) {
                    dialogs = AmsDialogs.readDialogs(c);
                }
                return dialogs != null ? dialogs : new ArrayList();
            }
        });
    }

    public void setActiveDialog(Dialog activeDialog) {
        if (activeDialog == null) {
            return;
        }
        if (this.mActiveDialog != null && !this.mActiveDialog.getDialogId().equals(activeDialog.getDialogId())) {
            LPMobileLog.d((String)TAG, (String)"MULTI_DIALOG_FLOW", (String)("Setting a new active dialog: " + activeDialog));
        }
        this.mDialogsByDialogId.put(activeDialog.getDialogId(), activeDialog);
        this.mActiveDialog = activeDialog;
    }

    public void closeActiveDialog() {
        Dialog activeDialog;
        if (this.mActiveDialog != null && (activeDialog = this.mDialogsByDialogId.get(this.mActiveDialog.getDialogId())) != null) {
            activeDialog.setState(DialogState.CLOSE);
        }
        this.mActiveDialog = null;
    }

    public void markPendingDialogsAsFailed(final String brandId) {
        Dialog dialog = this.mActiveDialog;
        if (dialog != null && (dialog.getState() == DialogState.PENDING || dialog.getState() == DialogState.QUEUED)) {
            dialog.setState(DialogState.CLOSE);
            dialog.setEndTimestamp(ClockUtils.getSyncedTimestamp());
        }
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String where = "state =? AND brand_id = ?";
                ContentValues contentValues = new ContentValues();
                contentValues.put("state", Integer.valueOf(DialogState.CLOSE.ordinal()));
                int result = AmsDialogs.this.getDB().update(contentValues, where, new String[]{String.valueOf(DialogState.PENDING.ordinal()), brandId});
                LPMobileLog.d((String)AmsDialogs.TAG, (String)String.format("Updated %d pending dialog as Closed on DB", result));
            }
        });
    }

    public boolean areMoreMessagesAvailableToFetch(String targetId) {
        boolean shouldFetch = false;
        ConversationViewParams conversationViewParams = this.mController.getConversationViewParams();
        if (conversationViewParams.getHistoryConversationsStateToDisplay() == LPConversationsHistoryStateToDisplay.OPEN) {
            return shouldFetch;
        }
        Cursor c = this.getNextDialogToFetch(targetId);
        if (c != null) {
            if (c.getCount() == 1 && c.moveToFirst()) {
                Dialog dialog = this.readDialog(c);
                shouldFetch = true;
                if (conversationViewParams.isFilterOn()) {
                    long historyConversationsMaxDays = (long)conversationViewParams.getHistoryConversationsMaxDays() * 86400000L;
                    switch (conversationViewParams.getHistoryConversationMaxDaysType()) {
                        case endConversationDate: {
                            if (dialog.getEndTimestamp() < System.currentTimeMillis() - historyConversationsMaxDays) {
                                shouldFetch = false;
                            }
                        }
                        case startConversationDate: {
                            if (dialog.getStartTimestamp() >= System.currentTimeMillis() - historyConversationsMaxDays) break;
                            shouldFetch = false;
                        }
                    }
                }
            } else {
                c.close();
            }
        }
        return shouldFetch;
    }

    public void saveMessagesResult(@Nullable String dialogId, final @NonNull ArrayList<ContentEventNotification> messagesResult, final boolean firstNotification, final boolean shouldUpdateUI, final @NonNull ICallback<Dialog, Exception> callback) {
        Dialog currentDialog = this.getDialogById(dialogId);
        if (currentDialog == null) {
            this.queryDialogById(dialogId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Dialog>(){

                public void onResult(Dialog dialog) {
                    if (dialog != null) {
                        AmsDialogs.this.saveMessages(dialog, messagesResult, firstNotification, shouldUpdateUI, (ICallback<Dialog, Exception>)callback);
                    }
                }
            }).execute();
        } else {
            this.saveMessages(currentDialog, messagesResult, firstNotification, shouldUpdateUI, callback);
        }
    }

    private void saveMessages(final Dialog dialog, final ArrayList<ContentEventNotification> messagesResult, final boolean firstNotification, final boolean shouldUpdateUI, final ICallback<Dialog, Exception> callback) {
        if (messagesResult.size() == 0) {
            LPMobileLog.d((String)TAG, (String)"No messages in query response.");
            int lastServerSequence = dialog.getLastServerSequence() == -1 ? 0 : dialog.getLastServerSequence();
            DataBaseCommand<Boolean> command = this.updateLastServerSequenceByDialogId(dialog.getDialogId(), lastServerSequence, 1, shouldUpdateUI);
            if (command != null) {
                command.execute();
            }
            callback.onError((Throwable)new Exception("Empty results - no messages"));
            return;
        }
        int lastContentSequence = -1;
        for (int i = messagesResult.size() - 1; i >= 0; --i) {
            if (messagesResult.get((int)i).sequence <= -1) continue;
            lastContentSequence = messagesResult.get((int)i).sequence;
            break;
        }
        LPMobileLog.d((String)TAG, (String)(dialog.getDialogId() + " - Last sequence event received in query messages response: " + lastContentSequence));
        if (lastContentSequence == -1 || lastContentSequence < dialog.getLastServerSequence()) {
            LPMobileLog.d((String)TAG, (String)(dialog.getDialogId() + " - didn't receive any new sequence " + lastContentSequence));
            callback.onSuccess((Object)dialog);
            return;
        }
        DataBaseCommand<Boolean> command = this.updateLastServerSequenceByDialogId(dialog.getDialogId(), lastContentSequence, lastContentSequence - dialog.getLastServerSequence(), shouldUpdateUI);
        command.setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Boolean>(){

            public void onResult(Boolean isEventExpected) {
                String originatorId = AmsDialogs.this.mController.getOriginatorId(dialog.getTargetId());
                long clockDiff = AmsDialogs.this.mController.mConnectionController.getClockDiff(dialog.getBrandId());
                AmsDialogs.this.mController.amsMessages.addMultipleMessages(messagesResult, originatorId, dialog.getBrandId(), dialog.getTargetId(), dialog.getDialogId(), dialog.getConversationId(), clockDiff, firstNotification, shouldUpdateUI).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Void>(){

                    public void onResult(Void data) {
                        callback.onSuccess((Object)dialog);
                        LPMobileLog.d((String)AmsDialogs.TAG, (String)("Finished saving " + messagesResult.size() + " messages for dialog id " + dialog.getDialogId()));
                    }
                }).execute();
            }
        });
        command.execute();
    }

    public static boolean isUmsSupportingDialogs() {
        return UmsCompatibilityManager.isSupportingDialogs();
    }

    public static void setIsUmsSupportingDialogs(boolean isSupportingDialogs) {
        UmsCompatibilityManager.setIsSupportingDialogs(isSupportingDialogs);
    }

    private static class UmsCompatibilityManager {
        private static Boolean _isSupportingDialogs;

        private UmsCompatibilityManager() {
        }

        private static boolean isSupportingDialogs() {
            if (_isSupportingDialogs == null) {
                _isSupportingDialogs = Infra.instance.getApplicationContext().getSharedPreferences("LP_COMPATIBILITY", 0).getBoolean("IS_SUPPORTING_DIALOGS", false);
                if (_isSupportingDialogs.booleanValue()) {
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)"MULTI_DIALOG_FLOW", (String)"Communicating with a new UMS, multi-dialog is supported!");
                } else {
                    LPMobileLog.d((String)AmsDialogs.TAG, (String)"MULTI_DIALOG_FLOW", (String)"Communicating with a legacy UMS, multi-dialog is not supported!");
                }
            }
            return _isSupportingDialogs;
        }

        public static void setIsSupportingDialogs(Boolean isSupportingDialogs) {
            if (UmsCompatibilityManager.isSupportingDialogs() == isSupportingDialogs) {
                return;
            }
            if (isSupportingDialogs.booleanValue()) {
                LPMobileLog.d((String)AmsDialogs.TAG, (String)"MULTI_DIALOG_FLOW", (String)"Communicating with UMS that has multi-dialog support!");
            } else {
                LPMobileLog.d((String)AmsDialogs.TAG, (String)"MULTI_DIALOG_FLOW", (String)"Communicating with UMS that HAS NO multi-dialog support!");
            }
            _isSupportingDialogs = isSupportingDialogs;
            Infra.instance.getApplicationContext().getSharedPreferences("LP_COMPATIBILITY", 0).edit().putBoolean("IS_SUPPORTING_DIALOGS", isSupportingDialogs.booleanValue()).apply();
        }

        private static class FileNames {
            public static final String TEMP_COMPATIBILITY_PERSISTENCE = "LP_COMPATIBILITY";

            private FileNames() {
            }
        }

        private static class Keys {
            public static final String IS_SUPPORTING_DIALOGS = "IS_SUPPORTING_DIALOGS";

            private Keys() {
            }
        }
    }

    public class BROADCASTS {
        public static final String UPDATE_DIALOG = "BROADCAST_UPDATE_DIALOG";
        public static final String UPDATE_CSAT_DIALOG = "BROADCAST_UPDATE_CSAT_DIALOG";
        public static final String UPDATE_DIALOGS_LIST = "BROADCAST_UPDATE_DIALOGS_LIST";
        public static final String UPDATE_DIALOG_CLOSED = "BROADCAST_UPDATE_DIALOG_CLOSED";
        public static final String UPDATE_NEW_DIALOG_MSG = "BROADCAST_UPDATE_NEW_DIALOG_MSG";
        public static final String UPDATE_UNREAD_MSG = "BROADCAST_UPDATE_DIALOG_UNREAD_MSG";
        public static final String UPDATE_DIALOG_TTR = "BROADCAST_UPDATE_DIALOG_TTR";
        public static final String UPDATE_FORM_URL = "BROADCAST_UPDATE_DIALOG_FORM_URL";
        public static final String UPDATE_DIALOG_OFF_HOURS = "BROADCAST_UPDATE_DIALOG_OFF_HOURS";
    }
}

