/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.model.Form;
import java.util.HashMap;
import java.util.Map;

public class FormsManager {
    private static final String TAG = FormsManager.class.getSimpleName();
    public static final String FORM_ID = "formId";
    public static final String INVITATION_ID = "invitationId";
    public static final String TITLE = "title";
    private Map<String, Form> mFormsMap = new HashMap<String, Form>();

    public void addForm(String id, Form form) {
        LPMobileLog.d((String)TAG, (String)("form add with id: " + id + " map size: " + this.mFormsMap.size()));
        if (this.mFormsMap != null) {
            this.mFormsMap.put(id, form);
        }
    }

    public void removeForm(String id) {
        if (this.mFormsMap != null) {
            this.mFormsMap.remove(id);
        }
    }

    public void updateForm(String id, String readOTK, String writeOTK) {
        if (this.mFormsMap != null && this.mFormsMap.containsKey(id)) {
            Form form = this.mFormsMap.get(id);
            form.setReadOTK(readOTK);
            form.setWriteOTK(writeOTK);
        } else {
            LPMobileLog.d((String)TAG, (String)("form with id: " + id + " could not be found in map "));
        }
        LPMobileLog.d((String)TAG, (String)("form update1 with id: " + id + " map size: " + this.mFormsMap.size()));
    }

    public void updateForm(String id, String submissionId) {
        if (this.mFormsMap != null && this.mFormsMap.containsKey(id)) {
            Form form = this.mFormsMap.get(id);
            form.setSubmissionId(submissionId);
            form.setFormStatus(Form.FormStatus.SUBMITTED);
        } else {
            LPMobileLog.d((String)TAG, (String)("form with id: " + id + " could not be found in map "));
        }
        LPMobileLog.d((String)TAG, (String)("form update2 with id: " + id + " map size: " + this.mFormsMap.size()));
    }

    public Form getForm(String id) {
        LPMobileLog.d((String)TAG, (String)("form get with id: " + id + " map size: " + this.mFormsMap.size()));
        return this.mFormsMap != null && this.mFormsMap.containsKey(id) ? this.mFormsMap.get(id) : null;
    }
}

