/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.Context;
import android.content.Intent;
import com.liveperson.infra.Command;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LocalBroadcastReceiver;

public class SynchronizedInternetConnectionCallback
implements Command {
    public static final String TAG = SynchronizedInternetConnectionCallback.class.getSimpleName();
    protected boolean handled = false;
    protected LocalBroadcastReceiver mLocalBroadcastReceiver;
    protected Runnable mCallback;

    public SynchronizedInternetConnectionCallback(Runnable callback) {
        this.mCallback = callback;
    }

    public void execute() {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.handleConnection();
        } else {
            this.registerToConnectionStateChanges();
            this.validateStatusDidNotChangedDuringRegistration();
        }
    }

    private void registerToConnectionStateChanges() {
        this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction("CONNECTION_CONNECTED").build(new LocalBroadcastReceiver.IOnReceive(){

            public void onBroadcastReceived(Context context, Intent intent) {
                SynchronizedInternetConnectionCallback.this.handleConnection();
            }
        });
    }

    private synchronized void validateStatusDidNotChangedDuringRegistration() {
        if (!this.handled && InternetConnectionService.isNetworkAvailable()) {
            this.handleConnection();
        }
    }

    private synchronized void handleConnection() {
        if (this.handled) {
            return;
        }
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
        }
        this.handled = true;
        this.mCallback.run();
    }
}

