/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import androidx.annotation.Nullable;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.PublishEvent;
import com.liveperson.api.request.message.PublishMessage;
import com.liveperson.api.request.message.TextPublishMessage;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.ConversationUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class SendMessageRequest
extends BaseAMSSocketRequest<PublishEvent.Response, SendMessageRequest> {
    private static final String TAG = SendMessageRequest.class.getSimpleName();
    private final String mTargetId;
    private final String mBrandId;
    private final String mEventId;
    private String mDialogId;
    private String mConversationId;
    protected PublishMessage mMessage;
    private PublishEvent.Type mType = PublishEvent.Type.ContentEvent;
    private ContentType mContentType = ContentType.text_plain;
    private Messaging mController;
    private DeliveryStatusUpdateInfo mInfo = null;

    public SendMessageRequest(Messaging controller, String eventId, String targetId, String brandId, String conversationId, String dialogId, String msg, ContentType contentType) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mMessage = new TextPublishMessage(msg);
        this.mTargetId = targetId;
        this.mBrandId = brandId;
        this.mEventId = eventId;
        this.mContentType = contentType;
    }

    public SendMessageRequest(Messaging controller, String eventId, String targetId, String brandId, String dialogId, String msg, String conversationId) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mMessage = new TextPublishMessage(msg);
        this.mTargetId = targetId;
        this.mBrandId = brandId;
        this.mEventId = eventId;
    }

    public SendMessageRequest(Messaging controller, String eventId, String targetId, String brandId, String dialogId, String conversationId) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mTargetId = targetId;
        this.mBrandId = brandId;
        this.mEventId = eventId;
    }

    public void setMessageContent(String msg) {
        this.mMessage = new TextPublishMessage(msg);
    }

    public void setInfo(@Nullable DeliveryStatusUpdateInfo info) {
        LPMobileLog.d((String)TAG, (String)("setInfo: Adding DeliveryStatusUpdateInfo with metadata: " + (info == null ? "null" : info.getMetadata())));
        this.mInfo = info;
    }

    public SendMessageRequest setConversationId(String conversationId) {
        this.mConversationId = conversationId;
        return this;
    }

    public SendMessageRequest setDialogId(String dialogId) {
        this.mDialogId = dialogId;
        return this;
    }

    public SendMessageRequest setContentType(ContentType contentType) {
        this.mContentType = contentType;
        return this;
    }

    public String getEventId() {
        return this.mEventId;
    }

    protected String getData() {
        return new PublishEvent(this.mDialogId, this.mConversationId, this.mMessage, this.mType, this.mContentType, this.mEventId, this.mInfo).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<PublishEvent.Response, SendMessageRequest> getResponseHandler() {
        return new BaseResponseHandler<PublishEvent.Response, SendMessageRequest>(){

            public String getAPIResponseType() {
                return "ms.PublishEventResponse";
            }

            protected PublishEvent.Response parse(JSONObject jsonObject) throws JSONException {
                return new PublishEvent.Response(jsonObject);
            }

            protected boolean handle(PublishEvent.Response data) {
                int serverSequence = data.getBody().sequence;
                LPMobileLog.i((String)TAG, (String)("Got send message response eventId = " + SendMessageRequest.this.mEventId + ", with sequence = " + serverSequence));
                ((SendMessageRequest)SendMessageRequest.this).mController.amsMessages.updateOnMessageAck(SendMessageRequest.this.mTargetId, SendMessageRequest.this.mDialogId, SendMessageRequest.this.mEventId, serverSequence);
                ((SendMessageRequest)SendMessageRequest.this).mController.amsDialogs.updateLastServerSequenceByDialogId(SendMessageRequest.this.mDialogId, serverSequence);
                ((SendMessageRequest)SendMessageRequest.this).mController.amsMessages.mMessageTimeoutQueue.remove((int)SendMessageRequest.this.getRequestId());
                ConversationUtils.showTTR(SendMessageRequest.this.mController, SendMessageRequest.this.mTargetId);
                return true;
            }

            protected void giveUp() {
                super.giveUp();
                LPMobileLog.i((String)TAG, (String)(SendMessageRequest.this.getRequestId() + ": Request lost (socket closed) for send message request."));
                ((SendMessageRequest)SendMessageRequest.this).mController.amsMessages.mMessageTimeoutQueue.remove((int)SendMessageRequest.this.getRequestId());
            }
        };
    }
}

