/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import androidx.annotation.Nullable;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.OnActionClickListener;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublishTextAction
extends BaseAction {
    public static final String TAG = PublishTextAction.class.getSimpleName();
    private String mText;
    private JSONArray mMetadata;

    public PublishTextAction(JSONObject jsonObject, @Nullable JSONArray metadataJsonArray) throws JSONException {
        super(jsonObject);
        this.mText = jsonObject.getString("text");
        this.mMetadata = metadataJsonArray;
    }

    @Override
    public OnActionClickListener getOnClickListener(Context context, final String brandId) {
        OnActionClickListener onClickListener = new OnActionClickListener(){

            @Override
            public void onClick() {
                LPMobileLog.d((String)TAG, (String)("onClick: sending text: " + PublishTextAction.this.mText + " with metadata: " + PublishTextAction.this.mMetadata));
                MessagingFactory.getInstance().getController().sendMessage(brandId, brandId, PublishTextAction.this.mText, new DeliveryStatusUpdateInfo(PublishTextAction.this.mMetadata));
            }
        };
        return onClickListener;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + "(\n");
        return sb.toString();
    }

    @Override
    public void accept(ElementVisitor visitor) {
    }
}

